# Chitosan based bioactive materials in tissue engineering applications-A review

Md. Minhajul Islama , Md. Shahruzzamana , Shanta Biswasa , Md. Nurus Sakiba , Taslim Ur Rashida,b,∗

a Department of Applied Chemistry and Chemical Engineering, Faculty of Engineering and Technology, University of Dhaka, Dhaka, 1000, Bangladesh b Fiber and Polymer Science, North Carolina State University, Campus Box 7616, Raleigh, NC, 27695, United States

# A R T I C L E I N F O

# A B S T R A C T

Keywords:   
Chitosan   
Bioactive material   
Scaffold   
Tissue engineering

In recent years, there have been increasingly rapid advances of using bioactive materials in tissue engineering applications. Bioactive materials constitute many different structures based upon ceramic, metallic or polymeric materials, and can elicit specific tissue responses. However, most of them are relatively brittle, stiff, and difficult to form into complex shapes. Hence, there has been a growing demand for preparing materials with tailored physical, biological, and mechanical properties, as well as predictable degradation behavior. Chitosan-based materials have been shown to be ideal bioactive materials due to their outstanding properties such as formability into different structures, and fabricability with a wide range of bioactive materials, in addition to their biocompatibility and biodegradability. This review highlights scientific findings concerning the use of innovative chitosan-based bioactive materials in the fields of tissue engineering, with an outlook into their future applications. It also covers latest developments in terms of constituents, fabrication technologies, structural, and bioactive properties of these materials that may represent an effective solution for tissue engineering materials, making them a realistic clinical alternative in the near future.

# 1. Introduction

Recently, biologically-active natural materials have garnered prominence to be used as potential materials in tissue engineering due to their unique characteristics. They are capable of imitating the human tissue structure because of their physical and chemical resemblance. It is worth to note that the demand for natural bioactive materials has been increasing over the last two decades because natural polymers are less toxic and more biocompatible compared to most synthetic polymers. At present, repairing and regenerating damaged tissue remains a great challenge in clinical settings. Synthesis of newer and robust biomaterials is necessary for rapid advancement of tissue engineering. A number of natural and synthetic materials such as: chitosan, collagen, gelatin (GL), alginate (Alg), silk fibroin, hydroxyapatite (HAp), hyaluronic acid (HA), polyethylene glycol (PEG), polylactic acid (PLA), poly(lactic-co-glycolic) acid (PGLA), and polycaprolactone (PCL) have been used for tissue engineering applications [1–6]. However, due to drawbacks such as uncontrolled degradation, risk of infection, insufficient mechanical properties, difficulties in bioaccumulation of degradation products, and local acidic environments, these materials still do not meet the requirements for tissue engineering. To overcome these challenges, researchers have developed hybrid biocomposites with superior properties. They combined two or more biopolymers along with inorganic materials to minimize the drawbacks of singlecomponent materials. Among the biopolymers, chitosan has been widely studied as a potential bioactive material because of its unique properties and availability. In recent years, chitosan has been shown to be a promising bioactive material for tissue engineering (bone, skin, cartilage, intervertebral disc, blood vessel, etc.) that can extensively be used for repairing diseased and damaged tissue.

Chitosan (CS) is a partially deacetylated form of chitin mainly procured from the exoskeleton of crustaceans [7]. It occupies a distinct position amongst other biomaterials due to its abundance, versatility, and unique properties including biodegradability, biocompatibility, non-toxicity, hydrophilicity, anti-bacterial and anti-fungal properties, and wound-healing effects [8]. In addition, the existence of $\beta$ -(1,4) glycosidic bonds between D-glucosamine and N-acetyl-D-glucosamine makes chitosan easy to be modified by chemical reactions with excellent elasticity, flexibility features, and a lower inflammatory response [9]. Moreover, the degradation of chitosan produces harmless amino sugars, which can be absorbed completely by human body. Therefore, all these criteria make chitosan a viable candidate for a broad range of biomedical applications such as drug delivery carriers, surgical thread, wound healing, and for tissue engineering [10–12].

Chitosan-based bioactive materials have been widely used in tissue engineering for the last few decades. The prominent fields of tissue engineering using chitosan for biomaterial fabrication are cartilage tissue engineering, bone tissue engineering, intervertebral disc tissue engineering, blood vessel tissue engineering, corneal regeneration, skin tissue engineering, tissue fixation, and periodontal tissue engineering [13–22]. Extensive studies using chitosan in combination with natural and synthetic materials have been reported to produce scaffolds for tissue engineering applications. Many attempts have been made to increase the mechanical strength and structural integrity of chitosanbased biomaterials by adding biopolymers such as chitin, silk, Alg, GL, PCL, PLA, HA, and bioactive nano ceramics such as HAp, $\mathrm { { S i O } } _ { 2 }$ , $\mathrm { T i O } _ { 2 } ,$ $\mathrm { Z r O } _ { 2 }$ , etc. [14,16–19].

To the authors’ best knowledge, many review articles have been reported on biomedical applications of chitosan. Few articles focus on tissue engineering applications, but none of them discuss developing new bioactive materials based on chitosan. Considering the rapidly growing interest in this field, this review attempts to be a comprehensive study of chitosan-based bioactive materials in the last decade in tissue engineering. At the beginning, a brief overview of structure, properties, and extraction of chitosan is presented. Next, a detailed summary of recent progress in tissue engineering applications is presented. At the end, future trends along with challenges will be discussed.

# 2. Chitosan: source and extraction

Chitosan is derived from chitin, the second largest naturally occurring polysaccharide found in the shells of living organisms such as crabs, lobsters, tortoise, shrimps and insects [23]. It is obtained by partial deacetylation of chitin using a chemical or biological method or a combination of both. Although there are no strict rules for defining chitosan, but in general, chitin with a degree of deacetylation (DD) of $7 0 \%$ or above is considered as chitosan [24]. Nevertheless, most commercially available chitosan have DD ranges within $7 0 \% - 9 0 \%$ ; even DD higher than $9 5 \%$ may be obtained via further deacetylation steps [25]. However, this may result in partial degradation of the polymer chains and an increase in the possibility of reacetylation. That's why the molecular weight of chitosan depends on the degree of deacetylation. The lower the deacetylation, the higher the molecular weight, which provides higher chemical stability and mechanical strength, but reduces the solubility in traditional solvents. The deacetylation of chitin is usually performed under the nitrogen environment or by the addition of sodium borohydride to the NaOH solution to avoid any undesirable side reactions. The average molecular weight of chitosan is approximately $1 . 2 \times 1 0 ^ { 5 } \mathrm { g m o l } ^ { - 1 }$ [25].

Several methods have been developed and proposed by researchers over the years for the preparation of chitosan from the shells of different crustaceans, insects, and fungi [26]. Chitosan can also be extracted from the unused fish scales of Labeo Rohita [27]. Two different methods have been widely used to extract chitosan from chitin with varying degree of acetylation. One of them is the heterogeneous deacetylation of solid chitin and the other is homogeneous deacetylation of pre-swollen chitin under vacuum in an aqueous medium [28]. In both cases, concentrated alkali solutions and long processing times are required for the deacetylation reaction. The processing time is governed by either heterogeneous or homogeneous conditions and may vary from 1 to nearly $^ \mathrm { ~ 8 0 ~ h ~ }$ . To reduce the long processing time and the large amount of alkali, alternative processing methods have been developed. Examples of these include the use of successive alkali treatments using thiophenol in DMSO [29]; thermo-mechanical processes using a cascade reactor operated under low alkali concentration [30]; flash treatment under saturated steam [31]; use of microwave dielectric heating [32]; and intermittent water washing [33,34]. Recent reports described some advanced techniques for chitosan extraction using high energy irradiation. Microwave irradiation is a widely used nonconventional energy source capable of transferring energy directly and quickly into the substrate and increasing the efficiency of the reaction [35]. In addition, the use of microwave irradiation can reduce the number of chemicals used in the process of extracting chitosan; however, the DD of chitosan achieved is not promising yet. Rashid et al. reported a $\gamma \cdot$ –irradiation technique for the preparation of chitosan from prawn shell, which increased the degree of deacetylation of chitin significantly with the use of relatively low alkali concentration [36]. The most common process for the preparation of chitosan is discussed below. Fig. 1 depicts conventional process for the extraction of chitosan from crustacean exoskeletal.

![](images/af7ebc1cae30c22507f14d4dda9bad253bd41928ec47e898da776c1800c69714.jpg)  
Fig. 1. Conventional process for the extraction of chitosan from crustacean exoskeletal (Modified from Ali et al. [37]).

# 2.1. Deproteinization

First, dried shells of crustaceans are treated with an alkali solution (e.g. NaOH, KOH etc.) to remove the protein. Then centrifugation is done to separate alkali insoluble fraction followed by repeated washing with distilled water until the pH becomes neutral.

# 2.2. Demineralization

Secondly, deproteinized shells are treated with dilute solution of a mineral acid (e.g. HCl) to remove minerals. After that, the acid-insoluble fraction is separated by centrifugation. The separated fraction is washed with distilled water until it is free of acid. Then, it is dried overnight to yield chitin, which is slightly pink in color.

# 2.3. Decolorization

The obtained chitin is decolorized by treating with an oxidizing agent like potassium permanganate, hydrogen peroxide, etc., followed by washing with oxalic acid solution. The obtained product is designated as purified chitin.

# 2.4. Deacetylation

The decolorized chitin is then subjected to deacetylation process by treating it with concentrated alkali solution for several hours to convert it into chitosan. The alkali fraction of the mixture is separated by centrifugation, and excess alkali is drained with a wash of distilled water until the pH reaches neutral. Finally, the obtained chitosan fraction is dried and stored at room temperature. To obtain the purest form, the raw chitosan is dissolved in aqueous $2 \%$ (w/v) acetic acid. Then, the insoluble material is filtered giving a clear supernatant solution, which is neutralized with NaOH solution resulting in a purified sample of chitosan as a white precipitate. Chitosan exists in a form of white to yellowish flakes, which can be converted to beads or powders. Further purification might be required to prepare medical and pharmaceutical-grade chitosan.

![](images/29e913e64c2a642246fbf989770e8805e19b63558523c646cb5c2d95ebc80297.jpg)  
Fig. 2. Structure of chitosan. –OH groups at C2 position of both the glucose structure are replaced by $\mathrm { - N H } _ { 2 }$ . As chitosan is not $1 0 0 \%$ deacetylated in most cases, some $\mathrm { N H } _ { 2 }$ groups will still be in acetylated form as $\mathbf { - N H C O C H _ { 3 } }$ (not shown in the figure).

# 3. Structure-properties relationship

Chitosan consists of $\beta$ -(1–4) linked D-glucosamine with randomly located $N _ { ☉ }$ -acetylglucosamine groups, depending on the chitin degree of deacetylation (Fig. 2) [38]. Strong alkaline hydrolysis is necessary for this conversion because of the resistance imposed by the trans arrangement of the C2–C3 substituents in the sugar ring [39]. The presence of hydrogen bonding in the chitosan molecular structure makes it rigid, and easily transformable into films with high mechanical strength. On the other hand, the presence of amino groups in the chitosan structure differentiates it from chitin, which gives chitosan many exceptional properties. The practical applications of chitin are limited due to its poor solubility. However, the amino groups of the chitosan D-glucosamine residues might be protonated and are soluble in diluted acidic aqueous solutions $\left( \mathrm { p H } \ < \ 6 \right)$ [40]. Chitosan dissolves in mineral acids like hydrochloric acid; however, it forms insoluble chitosan sulfate in sulfuric acid. Interestingly, this solubility pH dependency of chitosan allows for processing under mild conditions, which opens prospects to a wide variety of applications. Moreover, because of the presence of amino groups, chitosan efficiently produces various complexes with metal ions that are often used for heavy metal removal in wastewater treatment [41]. Chitosan is also used as a polyelectrolyte for the preparation of multilayered films using layer-bylayer deposition.

As chitosan is the only positively-charged naturally-occurring polysaccharide, it forms complexes with negatively charged synthetic polymers like poly(acrylic acid) and also forms films on negatively charged surfaces such as fats, cholesterol, proteins, and macromolecules. The amino and hydroxyl functional groups along chitosan chains enable them to form stable covalent bonds with other functional groups. At the hydroxyl groups, some non-specific reactions such as etherification and esterification can occur [42]. In addition, the amino group of D-glucosamine may be specifically quaternized or reacted with aldehyde under mild conditions. By applying all these techniques, it is possible to functionalize the chitosan backbone for other applications.

Chitosan exhibits amphiphilic characteristics because of its hydrophilic amino groups and hydrophobic acetyl groups in its molecular structure; this influences its physical properties in solutions and solid states. Chitosan exhibits other properties like fat binding ability, antibacterial activity, along with antifungal, mucoadhesive, analgesic, hemostatic activities, and wound-healing effects in humans and animals [33,43]. It can biodegrade into non-toxic residues and has proved to be biocompatible to some extent. It enables chitosan to play a vital role in various medical applications such as topical ocular application, implantation, or injection. All these unique characteristics make chitosan an exceptional candidate for tissue engineering applications.

# 4. Bioactive material for tissue engineering: Scope of chitosan

Materials that can affect their surroundings by stimulating a biological response are termed bioactive [44]. Such materials are classified into three types: osteoconductive, osteoproductive, and osteoinductive. The materials that can bond to hard tissue, such as bone, and stimulate its growth along the implant surface are known as osteoconductive materials. The materials that can stimulate the growth of new bone on the material away from the implant or bone interface, and are capable of bonding to soft tissue and cartilage are known as osteoproductive materials. Osteoinductive materials induce the bone formation at extraskeletal sites and are implanted in the tissues or organs where bone does not naturally grow [45,46]. To be effective bioactive materials in tissue engineering, the materials should exhibit fundamental properties such as: (i) biocompatibility with tissues; (ii) a biodegradability rate corresponding to the rate of new tissue formation; (iii) nontoxicity and nonimmunogenicity; (iv) optimal mechanical strength; and (v) adequate porosity and morphology for transporting cells, gases, metabolites, nutrients, and signal molecules both within and across materials and host environment [47]. A wide variety of bioactive materials based on metals, polymers, ceramics, and their composites play a salient role in tissue engineering fields such as bone, nerve, muscle, ligament regeneration, etc. [48,49]. However, bioactive devices made from biodegradable materials based on synthetic and/or natural polymers have advantages over metal or ceramic materials [50]. As degraded materials are bioresorbable, there is no need for second surgery to remove the implanted devices when the damaged tissue heals completely.

Although both synthetic and natural polymers are used as biomaterials, natural polymers have been one of the most widely used groups of bioactive materials. This can be attributed to their wide range of properties, bioactivity, better overall interactions with various cell types, and lack of immune response [51]. Synthetic polymers are inexpensive and pose better functionality compared to natural polymers and are sometimes used alone or in combination with natural polymers. Nevertheless, some synthetic polymers possess poor biocompatibility and immune responses or show toxicity resulting in inflammatory reactions and fibrous encapsulation [52]. Due to a rapidly increased demand in recent years, several biodegradable natural polymers have been exclusively explored as bioactive materials in tissue engineering applications. Among them, chitosan has been a fascinating contender in a broad spectrum of applications because of its distinctive physicochemical and biological properties including: biocompatibility, biodegradability to harmless products, nontoxicity and inertness, strong affinity to proteins, intrinsic antibacterial activity properties, etc. [47,53,54]. Some other properties of chitosan include: moldability into various forms, compatibility with a wide variety of delivery materials, drug carrying capacity, interconnected-porous structure formability, cationic nature, and the ability to form electrostatic interactions with anionic glycosaminoglycans (GAG) and proteoglycans and other negatively charged species [47,55]. To introduce desired properties, several derivatives of chitosan and chitin, and their composites along with a wide variety of functional materials have been investigated in tissue engineering applications. Fig. 3 illustrates a schematic presentation of different possible applications of chitosan-based bioactive materials. Recent research reports on these materials for tissue engineering applications are summarized chronologically in Table 1.

![](images/168119ebcb4c06f2c4ede588342a7ab65f18912faaefe156a534053ee53f685f.jpg)  
Fig. 3. Schematic representation of applications of chitosan-based bioactive materials.

# 5. Chitosan-based materials in tissue-engineering

# 5.1. Cartilage tissue engineering

Cartilage tissue is made of chondrocytes that produce extracellular matrix (ECM) proteins [56]. Articular cartilage imparts bone joints with important biomechanical functions such as wear resistance, loadbearing, and shock absorption [57]. It is difficult to treat cartilage tissue injury because this type of tissues are avascular, have a complex structure, exhibit very low cell population, and have a high amount of heterogeneity [58]. Moreover, they function under a strenuous environment. When the diameter of the injury damage is more than $4 \mathrm { m m }$ , spontaneous self-repair capacity becomes limited. Common treatments of cartilage tissue injury include mosaicplasty, autologous chondrocytes injection, or micro-fracture; but, they are not of the same structural construction as that of native cartilage [59]. So, tissue engineering technology has become an attractive option for articular cartilage repair. Chitosan has been used in cartilage tissue engineering applications because of its possibility to use it in different forms such as fibers, sponges, and hydrogels [60–62]. Another important factor that makes chitosan a desirable material in this field is its similarity with GAGs found in ECM [63]. GAGs have important properties like different electrostatic communications with cytokines, receptors, and cell adhesion molecules. Moreover, GAGs can stimulate cartilage chondrogenesis. Chitosan is capable of not only interacting electrostatically with negatively charged GAGs but also promoting chondrogenic activity and cartilage-specific protein expression [64]. So, as chitosan has the characteristics to contribute or stimulate the synthesis of cartilage's special GAGs, chitosan-based composite scaffolds have become popular for the restoration of articular cartilage [65,66]. The combination of chitosan and a biopolymer like gelatin, collagen, alginate and, silk fibroin has gained attraction in cartilage tissue engineering due to the non-toxicity and biocompatibility of the biopolymers [67–69]. Gelatin is an important component of cartilage ECM and its ability to uptake high water content is useful to supply nutrients via scaffolds or hydrogels [70,71]. In their recent report, Zhi-Sen et al. fabricated a strong, tough, and porous chitosan-gelatin hydrogel by in situ precipitation method which was able to exhibit a Young's modulus of 3.25 MPa and a compressive strength of $2 . 1 5 ~ \mathrm { M P a }$ [68]. In addition, highly porous structures assisted the growth of cells and nutrient transportation that enabled the hydrogel to exhibit superb adhesion and proliferation of human thyroid cartilage cells. Moreover, this hydrogel degraded by $6 5 . 9 \%$ over 70 days, which implied a good match with the regeneration rate of cartilage−making them a potential candidate for cartilage tissue engineering.

Similar types of protein-based hydrogels were prepared from chitosan and collagen for cartilage tissue engineering applications [72,73]. Kaviani et al. fabricated a hydrogel from chitosan, collagen and hydroxyapatite using a freeze drying method [73]. Collagen is a major component in articular cartilage ECM, and it is responsible for expressing the chondrocytes phenotype and supporting the chondrogenesis. But major problems of collagen include its rapid degradation and poor mechanical properties [74]. So, collagen was combined with chitosan to improve its mechanical property, reduce the biodegradation rate, and improve cell attachment and cell proliferation. The hydrogel had distinct interconnected macropores $( 3 0 \mathrm { - } 7 5 ~ \mu \mathrm { m } )$ and fine pores (less than $2 \ \mu \mathrm { m } )$ which enabled it to transport convective biological fluids. But the hydrogel was not able to exhibit satisfactory mechanical properties.

Chitosan has been extensively combined with silk fibroin, another protein-based biopolymer [75–79]. Silk fibroin, commonly extracted from Bombyx mori cocoons, has garnered attention in cartilage tissue engineering due to its biocompatibility, excellent mechanical properties, slow degradation, and cell adhesion and proliferation [80]. Singh et al. prepared a porous scaffold based on silk fibroin fiber reinforced chitosan by solubilizing silk fiber in $N , N \mathrm { \Omega }$ -Dimethylacetamide (DMAc) and LiBr solution [78]. Interestingly, this work used non-mulberry silk because of its superior biocompatibility, biodegradability, and mechanical stability compared to that of mulberry silk. Moreover, this non-mulberry silk is rich in arginine-glycine-aspartic acid (RGD) groups which facilitate cell attachment and proliferation [81]. The scaffold exhibited an interconnected micro porous structure with pore sizes in the range of $2 0 0 { - } 5 0 0 ~ { \mu \mathrm { m } }$ . This implied good compatibility for cell attachment, proliferation, and migration, and extracellular matrix production [82]. Moreover, the scaffold showed a contact angle of about $7 3 ^ { \circ }$ , which made it a good candidate for cell adhesion [83]. The scaffold also demonstrated good cytocompatibility and enhanced extracellular matrix deposition. As a result, it could facilitate human mesenchymal stem cells (hMSCs) to proliferate, colonize, differentiate, and initiate chondrogenesis.

<html><body><table><tr><td></td><td>Materials</td><td>In vivo/In vitro/ Ex vivo testing</td><td>Key features</td><td>Date and References</td></tr><tr><td>sueengineering</td><td>Chitosan-gelatin hydrogel</td><td>In vitro</td><td>Controlled biodegradability,cytocompatibility,microporous structures,and excellent mechanical properties; Strong,tough,and functional scaffolds having potential applications in cartilage tissue engineering</td><td>2015[68]</td></tr><tr><td></td><td>Glycol chitosan/poly(ethylene oxide-co-glycidol) hydrogels</td><td>In vivo In vitro</td><td>Chondrocytes were highly viable in the hydrogels,and no dedifferentiation of chondrocytes was observed; Demonstrated potential as an artificial extracellular matrix for cartilage tisue</td><td>2015[236]</td></tr><tr><td></td><td>Chitosan/gelatin/chondoitin-6-sulfate-hyaluronan (GCH) scaffold</td><td>In vitro</td><td>Exhibits larger pores,higher ultimate strain (stress)and elastic modulus,and lower stress relaxation percentage;</td><td>2015 [67]</td></tr><tr><td></td><td>Chitosan/poly(L-lactide) scaffolds using different crosslinkers</td><td></td><td>Incorporation of chitosan diminishes cell proliferation but up-regulates glycosaminoglycans (GAGs) and type II collagen (COL II) secretion Spongy scaffolds with improved physical properties;</td><td></td></tr><tr><td></td><td></td><td>In vitro</td><td>Promote chondrogenesis; In vivo condition is needed for better evaluation</td><td>2016 [95]</td></tr><tr><td></td><td>Poly(hydroxybutyrate)/chitosan blend fibrous scafolds Silk fibroin-chitosan porous scaffold</td><td>In vitro In vitro</td><td>Better attachment of Chondrocytes to the surfaces of the scaffolds Exhibits cell supportive property of the scaffold in terms of cell attachment, cell</td><td>2016[237]</td></tr><tr><td></td><td></td><td></td><td>viability,and proliferation</td><td>2016[77]</td></tr><tr><td></td><td>Chitosan scaffolds cross-linked with hydrothermal treatment</td><td>In vitro</td><td>Improved physical and mechanical properties of the scaffolds due to cross- linking;</td><td>2017[238]</td></tr><tr><td></td><td>Chitosan/PVA/graphene oxide composite nanofibers</td><td></td><td>Showed considerable proliferation in comparison to uncross-linked; Negligible impact of thermal treatment onporosity,pore sizeand permeability Increased mechanical properties of nanofibers;</td><td></td></tr><tr><td></td><td></td><td>In vitro</td><td>Chitosan/PVA/GO showed most appropriate environment for the growth of ATDC5 cells compared to chitosan/PVA</td><td>2017 [105]</td></tr><tr><td></td><td>Chitosan/poly(-lactide)/pectin composite scaffolds</td><td>In vitro</td><td>Superior neo-cartilage tissue regeneration; Exhibits suitable swelling property,moderate biodegradation and</td><td>2018[96]</td></tr><tr><td></td><td></td><td></td><td>hemocompatibility in nature and possess suitable mechanical strength for cartilage tissue regeneration</td><td></td></tr><tr><td></td><td>Chitosan/poly (3-hydroxybutyrate)- β-tricalcium phosphate scaffold</td><td>In vitro</td><td>Better mechanical and biological properties</td><td>2019 [97]</td></tr><tr><td>engineering</td><td>Chitosan/collagen/hydroxyapatite scaffold Chitosan/nano-hydroxyapatite/polyethylene glycol</td><td>In vitro In vitro</td><td>Inexpensive materials; Poor mechanical properties Good mechanical strength supportive of bone tissue ingrowths</td><td>2019 [73]</td></tr><tr><td></td><td>Chitosan/polycaprolactone -poly(ε-caprolactone) nanofibers</td><td>In vitro</td><td>Good cell attachment,cell viability,and metabolic activity for potential</td><td>2014 [127] 2015 [129]</td></tr><tr><td></td><td></td><td></td><td>applications in bone tissue engineering.</td><td></td></tr><tr><td></td><td>Chitosan/clay/hydroxyapatite scaffold</td><td>In vitro</td><td>Potential candidate for non-load bearing bone tissue engineering; Exhibits improved mechanical and in vitro biological properties</td><td>2016 [117]</td></tr><tr><td></td><td>Strontium hydroxyapatite/chitosan nanohybrid scaffolds</td><td>In vitro</td><td>Exhibits the excellent osteoinductivity</td><td>2017[125]</td></tr><tr><td></td><td>Chitosan/gelatin/bioactive glass nanoparticles composites</td><td>In vitro</td><td>Promising temporary injectable matrix for bone tissue engineering;</td><td>2018[153]</td></tr><tr><td></td><td>Clay/chitosan/hydroxyapatite/zinc oxide</td><td>In vitro</td><td>Improved elastic modulus Enhanced mechanical and biological properties for the application in bone tissue</td><td></td></tr><tr><td></td><td></td><td></td><td>engineering</td><td>2018[121]</td></tr><tr><td></td><td>Collagen/chitosan/polyethylene glycol/HAp</td><td>In vitro</td><td>Poor mechanical strength; Increased resistance to enzymatic degradation.</td><td>2019 [116]</td></tr><tr><td></td><td>Chitosan/poly(methyl methacrylate)/HAp</td><td>In vitro</td><td>Good mechanical strength; Canbeutilizedasascaffoldforbonecellsingrowthandalsobeusedfordrug</td><td>2019 [239]</td></tr><tr><td></td><td></td><td></td><td>delivery during the bone repairing</td><td></td></tr><tr><td></td><td>Chitosan/PEG/ZnO/CuO/biphasic calcium phosphate (BCP)</td><td>In vitro</td><td>Better bacteriostatic activity and exhibited no cytotoxic effects towards the Vero cell line;</td><td>2019 [126]</td></tr><tr><td></td><td></td><td></td><td>Enhanced mechanical properties</td><td></td></tr><tr><td></td><td>Chitosan anchored on porous poly(ε-caprolactone) (PCL)/bioactive glass (BG)</td><td>In vivo</td><td>Enhanced protein adsorption,cell adhesion,and osteogenic differentiation;</td><td>2019[240]</td></tr><tr><td></td><td>composite scaffolds</td><td>In vitro</td><td>Promoted cranial bone regeneration</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Chitosan/gelatin/bioactive glass nanocomposite hydrogels</td><td>In vivo</td><td>In vivo nd Invitroevaluationdemonstrated goodcandidateas tempoary</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td>2019 [241]</td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td>injectable matrix in order to promote bone regeneration</td><td></td></tr><tr><td></td><td></td><td>In vitro</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr></table></body></html>

<html><body><table><tr><td>Materials</td><td></td><td>In vivo/In vitro/ Ex vivo testing</td><td>Key features</td><td>Date and References</td></tr><tr><td>tissue</td><td>Chitosan/disodium-glycerophosphate</td><td>In vitro</td><td>Thermosensitive hydrogels; Shows excellent biocompatibilities and bioactivities for Adipose-derived stem cells (ADSCs) induced NP-like cells</td><td>2014[242]</td></tr><tr><td></td><td>Chitosan-poly(hydroxybutyrate-co-valerate) with chondroitin sulfate nanoparticles</td><td>In vitro</td><td>Significantly enhanced viability and chondrogenic differentiation of mesenchymal stem cells (MSCs);</td><td>2015[243]</td></tr><tr><td></td><td>Chitosan-β glycerophosphate/hyaluronic acid/chondroitin-6-sulfate/type I of Collagen/gelatin/fibroin silk (Ch-β-GP-HA-CS-Col-Ge-FS)hydrogel</td><td>In vitro</td><td>Offers great potential for NP tissue engineering At 4 ℃,hydrogel is an injectable transparent solution; Gelation temperature of hydrogel was 37 C;</td><td>2017 [177]</td></tr><tr><td></td><td>Chitosan/cellulose nanofibers</td><td>In vitro</td><td>Exhibit constant storage modulus over a wide range of strain Combating mechanical disc failure shows promising results as nanofibril- reinforced and non-cellularized bioactive biomaterial to promote intervertebral</td><td>2018[176]</td></tr><tr><td></td><td>Chitosan hydrogel with an outer ring of poly(ether ether ketone)(PEEK)and an inner layer of poly(butylene succinate-co-terephthalate) (PBST)</td><td>In vitro In vivo</td><td>disc regeneration Provides an appropriate environment for supporting IVD cells growth; Gross morphology and biological functions of the tissue engineered IVD are</td><td>2018[244]</td></tr><tr><td></td><td>Glycol chitosan-based hydrogel for treatment of degenerative disc disease</td><td>In vitro</td><td>similar to those of natural porcine IVD Thermo-sensitive injectable hydrogels with tunable thermo-sensitivity and enhanced stability;</td><td>2018[245]</td></tr><tr><td></td><td>Chitosan based hydrogels,filled with cellulose nanofibers (CNFs)</td><td>In vivo In vitro Ex vivo using</td><td>Can be used an alternative material for treatment of disc herniation Can be used for the repair and regeneration of the intervertebral disc (IVD) annulus fibrosus (AF) tissue</td><td>2019 [22]</td></tr><tr><td></td><td>Chitosan with various combinations of three gelling agents: sodium hydrogen carbonate (SHC) and/or beta-glycerophosphate (BGP)and/or phosphate buffer</td><td>spine pig models In vitro</td><td>A novel thermosensitive CH hydrogel; Exhibits enhanced strength and suitable cytocompatibility and rheological</td><td>2019 [179]</td></tr><tr><td>(PB) electrospun fibers</td><td>Chitosan hydrogel/poly (butylene succinate-co-terephthalate) copolyester (PBST)</td><td>In vitro</td><td>properties,similar to human NP tissue Mechanical property meets the requirement of the normal IVD; Both in vitro and in vivo experiments suggest the hydrogel as promising candidate</td><td>2019 [180]</td></tr><tr><td></td><td>Glycosamino-glycans/chitosan complex membranes</td><td>In vivo</td><td>for IVD replacement therapies Removes the shortcomings of existing small diameter vascular grafts by</td><td></td></tr><tr><td></td><td>Chitosan derived sandwiched tubular scaffold</td><td>In vitro In vivo</td><td>eliminating incomplete endothelialization and smooth muscle cell hyperplasia Regulation of pore diameter,very high burst strength,high suture retention</td><td>2000[183]</td></tr><tr><td></td><td>Electrospun collagen-chitosan-thermoplastic polyurethane nanofibrous scaffold</td><td>In vitro</td><td>strength. Flexible with a high tensile strength;</td><td>2006[184]</td></tr><tr><td></td><td></td><td>In vitro</td><td>No in-vivo experiments were done;degradation of plastics in-vivo remains a question</td><td>2011 [185]</td></tr><tr><td></td><td>Chitosan/poly ε-caprolactone nanofibrous scaffold</td><td>In vitro</td><td>Characterized with properties of anticoagulation and rapid inductionof re- endothelialization</td><td>2012 [246]</td></tr><tr><td></td><td>Chitosan/polycaprolactone (PCL)</td><td>In vitro In vivo</td><td>No calcification or aneurysm observed; Fast degradation and good cell infiltration but longer length grafts indicated</td><td>2016[182]</td></tr><tr><td>heparin</td><td>Chitosan/poly(vinyl alcohol) (PVA)-polycaprolactone (PCL) hydrogel containing</td><td>In vitro</td><td>lower patency High porous structure capable of carrying heparin;</td><td>2016 [247]</td></tr><tr><td></td><td>Chitosan/gelatin bi-layer microporous scaffold</td><td>In vivo In vitro</td><td>Increases new blood vessel formation into the hydrogels Tubular architecture;</td><td>2017 [187]</td></tr><tr><td></td><td>Poly-L-lactic acid/chitosan/collagen electrospun tube</td><td>In vitro</td><td>Similar morphological and mechanical properties of blood vessel Shows workable range of tensile strength, burst pressure,cell viability and</td><td></td></tr><tr><td></td><td>Chitosan/heparin layer by layer patch</td><td></td><td>hemolysis</td><td>2018[190]</td></tr><tr><td></td><td></td><td>In vitro In vivo</td><td>Showed long term patency and is workable with any substrate</td><td>2019 [186]</td></tr><tr><td>ion</td><td>3D printing PCL/chitosan/hydrogel biocomposites</td><td>In vitro</td><td>Elastic Moduli of range 56-174 MPa was obtained, Showed cell proliferation</td><td>2019 [248]</td></tr><tr><td></td><td>Collagen/chitosan hydrogel</td><td>In vitro</td><td>Good permeability to glucose and albumin; Regeneration of corneal epithelium,stroma and nerves</td><td>2008[249]</td></tr><tr><td></td><td></td><td>In vivo</td><td>Addition of chondroitin sulfate improved cell compatibility; suitable for</td><td></td></tr><tr><td></td><td>Hydroxypropyl chitosan/gelatin scaffold</td><td>In vitro</td><td>keratocytes growing on its surface</td><td>2009 [196]</td></tr></table></body></html>

<html><body><table><tr><td>tion</td><td>Materials</td><td>In vivo/In vitro/ Ex vivo testing</td><td>Key features</td><td>Date and References</td></tr><tr><td></td><td>Hydroxyethyl chitosan/gelatin and chondroitin sulfate blend scaffold</td><td>In vitro In vivo</td><td>Scaffold can be used as a carrier for corneal endothelial cell transplantation; Watercontent,onpermeabilityandglucosepermeabilityofthesaffoldwas remarkably close to the native cornea</td><td>2011[250]</td></tr><tr><td></td><td>Genipin crosslinked chitosan</td><td>In vitro In vivo</td><td>Improved cell preservation and better anti-inflammatory activities than non- crosslinked counterparts but free-floating implants cause mechanical damage to</td><td>2012[251]</td></tr><tr><td></td><td>Chitosan/silk fibroin scaffold</td><td>In vitro</td><td>tissue Reconstructed comparable lamellar cornea</td><td>2013[252]</td></tr><tr><td></td><td>Chitosan/PEG hydrogel</td><td>In vivo In vitro</td><td>Good candidate for the regeneration and transplantation of Corneal Endothelial Cells; High optical transparency with cell adhesion and proliferation; Display</td><td>2013[198]</td></tr><tr><td></td><td> Silicone modified chitosan membrane</td><td>In vitro</td><td>desirable mechanical, optical and degradation properties High tensile strength and inexpensive support for culturing corneal cels compared to currently used amniotic membrane</td><td>2018[253]</td></tr><tr><td></td><td>Carboxymethyl chitosan and sodium alginate dialdehyde hydrogel</td><td>In vitro</td><td>Remarkable healing effect for alkali burn wounds with significant improvement in epithelial reconstruction; Post injection inflammation was observed</td><td>2018[254]</td></tr><tr><td></td><td>Chitosan scaffold with PVA and amine coupling</td><td>In vivo In vitro</td><td>Addresses the issues of present amniotic membrane for corneal epithelium;</td><td>2018 [255]</td></tr><tr><td></td><td>Thiolated chitosan nanoparticles</td><td>In vitro</td><td>Better mechanical strength Potential anti-fibrotic and anti-angiogenic therapeutics for cormeal injuries</td><td>2018[197]</td></tr><tr><td></td><td>Carboxymethyl chitosan/gelatin/hyaluronic acid blended membrane</td><td>In vivo In vitro</td><td>Improves corneal epithelial reconstruction and restore cornea transparency and</td><td>2018[256]</td></tr><tr><td></td><td>Chitosan/polycaprolactone blend</td><td>In vivo In vitro</td><td>thickness A suitable alternative for cadaveric cornea transplantation; Limited</td><td>2019 [199]</td></tr><tr><td>sue engineering</td><td>Chitosan/polycaprolactone blend fibrous mat</td><td></td><td>biodegradability and cell support after long term co-culture from artificial substrate Showed improved swelling property,tensile strength,thermal stability and</td><td></td></tr><tr><td></td><td></td><td>In vitro</td><td>surface roughness; Better attachment and proliferation of keratinocytes</td><td>2015[257]</td></tr><tr><td></td><td>Collagen/chitosan scaffolds Gelatin/carboxymethyl chitosan-based scaffolds</td><td>In vitro In vitro</td><td>Effectively promotes and accelerate cell proliferation Provide growth and proliferation along with potential support for angiogenesis during wound healing;</td><td>2016[258] 2016[259]</td></tr><tr><td></td><td></td><td></td><td>Show sustained ampicillin and bovine serum albumin release,confirming their suitability as a therapeutic delivery vehicle during wound healing</td><td></td></tr><tr><td></td><td>Chitosan/poly(caprolactone) nanofibers</td><td>In vitro In vivo</td><td>Increased the wound healing rate and promoted complete wound closure Possess promising physico-chemical and biological;</td><td>2017[260]</td></tr><tr><td></td><td>Chitosan/gelatin/polycaprolactone nanofibrous scaffold</td><td>In vitro</td><td>In vivo testing should be performed to evaluate posibility in human body application</td><td>2017 [261]</td></tr><tr><td></td><td>Henna leaves extract-loaded chitosan based nanofibrous mats</td><td>In vitro In vivo</td><td>Incorporation of Henna extract exhibited significant synergistic antibacterial activity against bacterial cells; In vivo experiment supported cell viability and proliferation of human foreskin</td><td>2017 [262]</td></tr><tr><td></td><td>Chitosan/g-pluronic hydrogel (nanocurcumin-formulated)</td><td>In vitro</td><td>fibroblast cells on the prepared scaffolds Enhances burn wound repair;</td><td>2018 [263]</td></tr><tr><td></td><td>Cellulose/chitosan hybrid sponges</td><td>In vivo In vitro</td><td>Has great potential to apply for wound healing Exhibits superior blood coagulation,adsorption performance,and shape recovery</td><td>2018[264]</td></tr><tr><td></td><td></td><td></td><td>properties; Displays good biocompatibility to human foreskin fibroblast cells</td><td></td></tr><tr><td></td><td>Gelatin/chitosan electrospun scaffold</td><td>In vitro</td><td>Possess porosity of 92% maintaining good tensile strength; Exhibiting spindle-like shape</td><td>2018[209]</td></tr><tr><td></td><td>Chitosan/maleic terminated polyethylene glycol hydrogels</td><td>In vitro In vivo</td><td>Show a porous structure with swelling ratio in the range of 240-280%; Good candidate for wound healing applications as they enhance the wound</td><td>2019[265]</td></tr><tr><td></td><td>Chitosan/vitamin C/lactic acid composite membrane</td><td>In vitro</td><td>contraction process with improved vascularization. Provides optimum environment for skin cell(fibroblast NIH 3T3 cel-line) attachment,growth,and spreading</td><td>2019 [214]</td></tr></table></body></html>

<html><body><table><tr><td>Materials</td><td>In vivo/In vitro/ Ex vivo testing</td><td>Key features</td><td>Date and References</td></tr><tr><td>High performance chitosan prepared by in situ coagulation</td><td>In vitro</td><td>Better bending strength, bending modulus and shear strength; Can be used in Internal bone fracture fixation</td><td>2003 [215]</td></tr><tr><td>Chitosan/chitin coated polyester fabric</td><td>In vitro In vivo</td><td>Effectively induced bone formation in the spaces between the fibers and enhanced biological fixation of the fibrous materials to the bone; Good</td><td>2008[223]</td></tr><tr><td>Chitosan rods crosslinked at higher temperature</td><td>In vitro</td><td>mechanical properties Good mechanical properties; Lower water absorption;</td><td>2008 [217]</td></tr><tr><td>Chitosan and hydroxyapatite</td><td>In vitro</td><td>Can be used in Internal bone fracture fixation Improved mechanical properties (bending strength and bending modulus);</td><td>2010[220]</td></tr><tr><td>Chitin fiber and chitosan composites</td><td>In vitro</td><td>Can be used in Internal bone fracture fixation Better crystallinity and thermal stability; Insuficient bending strength and bending modulus;</td><td>2010 [219]</td></tr><tr><td>Chitin with glutaraldehyde as crosslinker</td><td></td><td>Possible application as a bone fracture internal fixation element. Improved mechanical properties;</td><td></td></tr><tr><td>Chitosan with poly(p-amino-phenylacetylene)/multi-walled carbon nanotubes</td><td>In vitro In vivo</td><td>Can be used in internal bone fracture fixation</td><td>2010 [218]</td></tr><tr><td>impregnated by superparamagnetic Fe3O4</td><td>In vitro</td><td>Good cell proliferation, bending strength and bending modulus make them better candidate for bone fracture fixing</td><td>2011[222]</td></tr><tr><td>Chitosan rod</td><td>In vitro</td><td>CS rods with excellent mechanical properties are a good candidate for bone fracture internal fixation.</td><td>2011 [218]</td></tr><tr><td>Chitosan and nanocrystalline hydroxyapatite composites Periodate/oxidized chitosan/polyethylene glycol/tyramine hydrogel</td><td>In vitro</td><td>Higher mechanical strength,positive cellular behavior and cell compatibility</td><td>2012 [221]</td></tr><tr><td>Oxidized dextran and chitosan based surgical adhesives</td><td>In vitro In vivo</td><td>Highly cytocompatible and exhibited high tensile strength on porcine skin; Demonstrated good performance in wound sealing</td><td>2015[266]</td></tr><tr><td></td><td>In vitro In vivo</td><td>Can stop bleeding, bond the tissues well as well as possess tissue sealing properties; Act as a hemostat,as vehicle for delivery of drugs and therapeutic peptides and</td><td>2017[267]</td></tr><tr><td>Microfiber nonwoven chitin fabric</td><td>In vitro</td><td>proteins Promoted bone formation in the bone tunnel and increased the density of</td><td>2018[268]</td></tr><tr><td>Chitosan-gelatin scaffolds with embedded chitosan/plasmid DNA nanoparticles</td><td>In vivo In vitro</td><td>collagen fibers Sustained and steady release of DNA,formed connective tissue like structure;</td><td>2008[232]</td></tr><tr><td>encoding platelet derived growth factor (PDGF)</td><td></td><td>Pore size preservation; promote periodontal ligament cells (PDLCs) proliferation, which would help defects regeneration in periodontal tissue engineering</td><td></td></tr><tr><td>Chitosan-tripolyphosphate</td><td>In vitro</td><td>Prevents bacterial growth in dental cone; Slow release of incorporated drug; good antibacterial agent; Crosslinking decreases sponge thickness and diameter</td><td>2008[230]</td></tr><tr><td>Chitosan- HAp scafolds loaded with basic fibroblast growth factor (bFGF)</td><td>In vitro</td><td>Three-dimensional structure provides better cellular structure,proliferation,and mineralization suitable for periodontal tissue engineering</td><td>2009 [231]</td></tr><tr><td>Chitosan-bioactive glass nanoparticles composite membranes</td><td>In vitro</td><td>Increases bioactivity properties;potentially be used as a temporary guided tissue regeneration membrane in periodontal regeneration</td><td>2012 [235]</td></tr><tr><td>Chitosan scaffolds with morphogenetic protein-6 (BMP-6) loaded alginate microspheres</td><td>In vitro</td><td>A controlled release vehicle for BMP-6 delivery; Enhances the osteoblastic differentiation of bone marrow</td><td>2012 [233]</td></tr><tr><td>Chitosan and quaternized chitosan (HTCC)</td><td>In vitro</td><td>Chitosan acts as anti-inflammatory and quartrernized chitosan acts against periodontal inflammation</td><td>2013[269]</td></tr><tr><td>Chitosan microparticles loaded with clindamycin phosphate (CDP) Chitosan/hyaluronic acid hydrogel scaffold</td><td>In vitro</td><td>Good drug delivery and sustained antimicrobial efficacy</td><td>2014[270]</td></tr><tr><td>Chitosan based trilayer scafold cross-linked with genipin</td><td>In vitro In vitro</td><td>Promotes cell migration for periodontal regeneration Possess high biocompatibility, tissue ingrowth,and vascularization within the scaffold</td><td>2015[271]</td></tr><tr><td></td><td>In vivo</td><td></td><td>2017 [272]</td></tr><tr><td>Chitosan gel</td><td>In vitro</td><td>Good local delivery system for a statin group drug,atorvastatin which is</td><td>2018 [273]</td></tr><tr><td>Pure polylactic acid (PLA)and chitosan/PLA blends nanofibrous scaffolds</td><td>In vivo In vitro</td><td>promising for the treatment of periodontal disease. Promoted cell adhesion,osteogenic diffrentiation of bone marrow stem cells</td><td>2018 [274]</td></tr><tr><td></td><td></td><td>(BMSCs); Caused higher expression of inflammatory mediators and TLR4(Toll-like receptor 4) of human periodontal ligament cells</td><td></td></tr><tr><td>Chitosan/dicarboxylic acid scaffold</td><td>In vitro In vivo</td><td>Promoted bone tissue repair in a critical-size mouse calvarial defect; Can serve as a carrier for stem cells or used alone to repair bone defects</td><td>2019 [275]</td></tr><tr><td>Transforming growth factor-β3/chitosan sponge</td><td>In vitro</td><td>Promotes osteogenic differentiation of human periodontal ligament stem cells</td><td>2019 [276]</td></tr><tr><td>Poly(lactic-co-glycolic acid)/chitosan/Ag nanoparticles</td><td>In vivo In vitro</td><td>(hPDLSCs); Can repair periodontal soft and hard tissue defects No cytotoxicity and contributed to cell mineralization</td><td></td></tr><tr><td></td><td>In vivo</td><td></td><td>2019 [277]</td></tr></table></body></html>

Some researchers used derivatives of chitosan in combination with silk fibroin to develop hydrogels for applications in cartilage tissue [84–86]. Li et al. fabricated a carboxymethyl chitosan and silk fibroin hydrogel by chemical cross-linking with horseradish peroxidase and hydrogen peroxide $\left( \mathrm { H R P / H _ { 2 } O _ { 2 } } \right)$ [84]. Carboxymethyl chitosan (CMC) is one of the most commonly used derivatives of chitosan. CMC derivatives can interact with cells resulting in cell growth and tissue regeneration [87]. Moreover, it has higher water solubility and better bioactivity compared to that of chitosan. Hydrogels made from CMC and silk fibroin by enzymatic cross-linking (horseradish peroxidase and hydrogen peroxide) and $\beta$ -sheet cross linking (ethanol treatment), have a tunable $\beta$ -sheet structure. The tendency of silk fibroin to form large $\beta \cdot$ sheet aggregates via conformation transition from random coil to $\beta \cdot$ sheet structure affects the mechanical properties of the hydrogels [88]. So a tunable $\beta$ -sheet structure, via increased ethanol treatment time, allows for the adjustment of several important characteristics of the composite such as: pore size (from 50 to $3 0 0 \mu \mathrm { m } )$ ), equilibrium swelling (from $1 7 8 . 1 ~ \pm ~ 2 . 6 \%$ to $9 1 . 9 ~ \pm ~ 0 . 9 \% )$ , degradation (from $1 0 0 \%$ to $9 \%$ reduction in mass over 56 days), rheological properties (storage modulus from 177 Pa to $^ { 8 8 , 9 0 4 \mathrm { ~ P a } ) }$ , and mechanical properties (compressive modulus from 13 to $8 2 9 \ \mathrm { k P a } )$ ). In vitro cellular experiments demonstrated that the hydrogels supported the adhesion, proliferation, glycosaminoglycan synthesis, and chondrogenic phenotype of rabbit articular chondrocytes. Moreover, in vivo test with a mouse model revealed no infections or local inflammatory responses. These results make the hydrogel an encouraging candidate for cartilage tissue engineering.

Despite having a few disadvantages, synthetic polymers like polycaprolactone [64,89], polylactic acid [90,91] and poly(ethylene oxide) [92,93] have been combined with chitosan to investigate their applicability in cartilage tissue engineering [94]. For the regeneration of cartilage tissue, chitosan and poly(L-lactide) (PLLA) based composite scaffold was prepared by freeze drying followed by cross-linking using a mixture of 1-ethyl-3-(3-dimethylaminopropyl) carbodiimide hydrochloride (EDC), n-hydroxysuccinimide (NHS), and chondroitin sulfate (CS) [95]. The scaffold exhibited pore sizes in the range of $3 8 \mathrm { - } 1 7 2 \ \mu \mathrm { m }$ It was found that the scaffold was biodegradable but the addition of PLLA slowed the degradation rate. Moreover, the scaffold could promote chondrogenesis as the GAG content of the mature chondrocyte was $4 0 ~ \mu \ g$ per ml and the viability was approximately $9 0 \%$ , which implied the possible application of the scaffold in cartilage tissue engineering. In another work, the same author prepared chitosan-poly(Llactide) based composite scaffolds for cartilage tissue regeneration but added pectin to it [96]. This scaffold exhibited pore sizes in the range $4 9 { - } 1 7 0 \mu \mathrm { m }$ and the percentage of porosity was in the range of $7 9 - 8 4 \%$ . Histopathological analysis revealed formation and deposition of the extracellular matrix at the site of a cell scaffold, which made it more suitable for cartilage tissue engineering compared to that in the previous work.

Chitosan has been combined with bioceramics such as calcium phosphate, calcium polyphosphate, or hydroxyapatite for cartilage tissue engineering because of their ability to improve osteoconductivity, strength, and hardness of the fabricated scaffold [97–99]. Keikhaei et al. fabricated a chitosan-poly(3-hydroxybutyrate) (PHB) scaffold with $\beta$ -tricalcium phosphate $( \beta$ -TCP) as reinforcing material via electrospinning, which is a new and interesting approach in scaffold fabrication [97,100]. The electrospun scaffold possessed high porosity, extensive surface area, and better mechanical protection [101]. Moreover, it had other important properties such as biocompatibility, and a degradation rate similar to that of an osteoarthritis defect repair cases [102]. This nanocomposite scaffold exhibited an impressive tensile strength of $9 \ \mathrm { M P a }$ with $8 2 \%$ porosity. Addition of $\beta$ -TCP made the scaffold hydrophilic which acted as a stimulating factor in chondrocyte growth and cell proliferation.

Some other combinations of chitosan used in cartilage tissue engineering are chitosan-hyaluronic acid [103,104], chitosan-graphene oxide [65,105], chitosan-oligopyrrole [66], carbon nanotube [106,107], and chitosan-chondroitin sulfate [108,109]. These combinations could be promising solutions to cartilage injury if thoroughly investigated. Most of the researches conducted in this field are still in developmental stage and results presented are based on in vitro experiments. For application in human body, a detailed in vivo evaluation is needed.

# 5.2. Bone tissue engineering

Bone tissue engineering is an interdisciplinary field where knowledge from chemistry, engineering, and life science is fused to design, construct, and develop three-dimensional (3D) scaffolds with a highly interconnected porous structure. The most important requirement of these scaffolds is to match the properties of the tissue which it will replace. On top of that, these scaffolds should possess biocompatibility, osteoconductivity, osteoinductivity, and mechanical strength to restore bones which have been lost or damaged [110].

Extensive studies have been conducted using natural and synthetic materials to produce scaffolds for bone tissue engineering. Chitosan has been given great importance in the field of scaffold fabrication [14,15]. However, the mechanical properties of chitosan scaffolds are inferior to those of normal bone [111,112]. As a result, they are unable to support the load-bearing requirement of bone implants. Moreover, chitosan itself is not osteoconductive which makes it incapable of imitating the properties of natural bones. Biopolymers such as chitin, silk, Alg, GL, PCL, PLA, and HA, and bioactive nano ceramics such as HAp, $\mathrm { { S i O } } _ { 2 }$ , $\mathrm { T i O } _ { 2 }$ , $\mathrm { Z r O } _ { 2 }$ , etc. with chitosan have been fabricated to increase the mechanical strength and structural integrity of chitosan biocomposites for bone tissue engineering applications [14,16–19]. According to many researchers, HAp $\mathrm { [ C a _ { 1 0 } ( P O _ { 4 } ) _ { 6 } ( O H ) _ { 2 } ] }$ can improve the mechanical properties and osteoconductivity of implants. It is one of the most stable forms of calcium phosphate and occurs as a major component in bone $( 6 0 - 6 5 \% )$ [113]. HAp also aids in new bone formation without resorption and interaction with the living system. Additionally, nanostructured HAp exhibits high surface area and better bioactivity. As a result, composites made of chitosan and HAp can mimic the organic and inorganic portion of natural bone and is currently being further studied [114,115].

A porous 3D scaffold was prepared from collagen-chitosan-polyethylene glycol-HAp combination by freeze drying using dehydrothermal cross‐linking techniques [116]. This work investigated the effect of HAp in chitosan-based material. Mechanical properties of chitosan-collagen scaffolds improved after the addition of HAp and PEG to the composites. This implied that the compression resistance and deformation rate improved [116]. However, due to increased brittleness, composites prepared from HAp and chitosan show poor mechanical strength. To overcome this problem, Kar et al. prepared a composite by adding clay minerals into HAp-chitosan composite [117]. Clay has a layered silicate structure and hence the incorporation of montmorillonite (MMT)-type clay into a composite can enhance mechanical properties [118]. The authors modified the MMT clay with alkylammonium salts to improve polymer matrix miscibility [117]. This composite exhibited improved mechanical property and bioactivity as well as non-toxicity to MG 63 osteoblast cell lines. Although there was less cell viability, it remained within an acceptable range. However, the composite was still able to demonstrate only $0 . 5 6 ~ \mathrm { \ M P a }$ of tensile strength compared to that of human bone $( \sim 5 0 \ \mathrm { \ M P a } )$ [119]. This composite has the potential to be used for non-load-bearing bone tissue engineering applications. The addition of trace metal ions is an attractive proposition to mimic bone mechanical strength because it was found to enhance the mechanical and biological performance of composites. One of these metals, zinc, can promote bone density and prevent bone loss [120]. In a recent article, a biomimetic chitosan/hydroxyapatite-zinc oxide nanocomposites supported with organicallymodified montmorillonite clay (OMMT) were reported [121]. The composite had a tensile strength of $3 0 . 1 3 ~ \mathrm { M P a }$ , which is a substantial improvement from previous work. Moreover, the composite showed a decreased swelling capacity with increasing hydrophobic-modified clay content. This composite also exhibited good pH and erythrocyte compatibility, impressive antibacterial properties, and cytocompatibility with MG-63 cells [121].

Most of the chitosan-based composite scaffolds exhibit the required biocompatibility and osteoconductivity, but some lack osteoinductivity. The two most common practices to accelerate osteogenic differentiation are loading cytokines into scaffolds or doping trace elements in bone scaffolds [122]. Cytokines such as bone morphogenetic protein-2 (BMP2), vascular endothelial growth factor (VEGF), and platelet-derived growth factor (PDGF) are mostly used to improve osteogenic capacity. But a major difficulty with this method is the loading-release properties of cytokines, which are difficult to control because they are governed by scaffold microstructures and parameters such as: chemical composition, porous structure, surface characteristic, pH value, and temperature [123]. On the other hand, doping bioactive trace elements like $\mathsf { S r } ^ { 2 + }$ , $\mathrm { Z n } ^ { 2 + }$ , $\mathrm { M g } ^ { 2 + }$ , $\mathrm { C u } ^ { 2 + }$ , $\ S \mathrm { i } ^ { 4 + }$ into HAp by ion substitution can accelerate angiogenesis and stimulate the osteogenic differentiation of mesenchymal stem cells (MSCs). Strontium (Sr) has become an attractive option in bone tissue engineering because of its ability to increase new bone formation and inhibit bone resorption [124]. Yong et al. fabricated chitosan, strontium, and HAp nanohybrid scaffolds to investigate the effect of Sr percentages in Sr-HAp nanocrystals on osteoinductivity [125]. The addition of $\mathtt { s r }$ in HAp increased the cell volumes and axial lengths but decreased the particle size. Sr-HAp micropores of $1 0 0 { - } 4 0 0 ~ { \mu \mathrm { m } }$ were reported to be uniformly present throughout the scaffolds. As a result, the released $\mathsf { S r } ^ { 2 + }$ ions from the scaffolds facilitated cell proliferation and osteogenic differentiation. This showed that the addition of Sr in the Sr-Hap-chitosan scaffolds improves alkaline phosphatase (ALP) activity, extracellular matrix (ECM) mineralization, and osteogenic-related COL-1 and ALP expression levels. Additionally, Sr-HAp chitosan scaffolds exhibited superb osteoinductivity because of the synergetic effect between $\mathrm { C a } ^ { 2 + }$ and $\mathsf { S r } ^ { 2 + }$ ions, which makes it an excellent candidate for bone engineering application.

Chitosan has been combined with synthetic polymers like polymethyl methacrylate (PMMA), polyethylene glycol [126,127], polycaprolactone [128,129], polylactic acid [130,131], etc. to fabricate scaffolds for bone tissue engineering to influence the mechanical properties and biocompatibility of the final composite [132]. Exclusively synthetic polymer scaffolds suffer from poor cell affinity because of their low hydrophilicity and lack of cell recognition sites; therefore, combinations of synthetic and natural polymers have become more popular in research [54,133].

PMMA has been used as bone cement for a long time because of properties like mechanical strength and moldability [134]. However, PMMA can cause thermal damage to surrounding tissue because it polymerizes at elevated temperatures. To eliminate this problem, PMMA has been combined with chitosan and some bioinorganic materials such as bioactive glass (BG), and calcium phosphate $( \mathsf { C a } _ { 3 } ( \mathsf { P O } _ { 4 } ) _ { 2 } )$ . Tanatsaparn et al. fabricated composite scaffolds by combining mineral ion loaded hydroxyapatite (mHAp) particles with chitosan-graft-poly (methyl methacrylate) [135]. The composite exhibited good compressive strength and micro pore structure. Additionally, it was able to release two types of biomolecules, a model drug, doxorubicin (DOX), and a protein, BSA, over $^ { 2 5 \mathrm { ~ h ~ } }$ . Moreover, the scaffold supported cell attachment and proliferation, and ALP activity of UMR-106 osteoblast cells. In another work, chitosan was crosslinked with PEG to overcome disadvantages associated with chitosan membranes [126]. PEG is a synthetic polymer approved by the Food and Drug Administration (FDA, USA) for drug delivery systems. It is a hydrophilic, biocompatible, non-toxic, non-immunogenic, and non-inflammatory polymer [136]. As a result, chitosan and PEG-based membranes could be used as coating material for bone implants. This membrane can be incorporated with particles of biphasic calcium phosphate (BCP), zinc oxide (ZnO), and copper oxide (CuO) [136].

Most of these synthetic and natural polymer hybrid scaffolds suffer from different issues such as detachment under physiological condition, phase separation, and non-uniform dispersion of biomolecules because of mismatches in physiochemical properties [137–139]. To counter this, an interesting approach was taken by X Jing et al. [129]. They fabricated an unusually shaped scaffold having a shish kebab-like structure. The scaffold was prepared by crystallizing chitosan-polycaprolactone copolymers on electrospun poly(ε-caprolactone) (PCL) nanofibers (Fig. 4). One advantage of electrospun structures is that the morphology is similar to that of the ECM [140]. Unfortunately, the surface of electrospun fibers is smooth, a property not conducive to cell adhesion [141,142]. This tempted the authors of this work to prepare a rough electrospun scaffold. Electrospun PCL nanofibers were used as a “shish” to prompt crystallization of PCL domains in chitosan-polycaprolactone copolymers. Chitosan-caprolactone formed well−shaped kebabs on the PCL nanofiber surface. Cell viability tests showed that enhanced surface roughness provided by the shish-kebab structure enabled cell attachment and proliferation. Moreover, the presence of chitosan-polycaprolactone “kebabs” introduced integrin binding sites resulting in increased cell viability and proliferation.

Natural polymers are popular candidates to fabricate scaffolds in combination with chitosan for bone tissue engineering. Common natural polymers like gelatin [143,144], hyaluronic acid [145,146], collagen [147,148], fibroin [149,150], and alginate [151,152] have been used extensively in this sector. An interesting in situ-forming hydrogel was prepared by Moreira et al. from chitosan, gelatin, and bioactive glass [153]. This is an injectable hydrogel that undergoes gelation in situ when stimulated by body temperature. This hydrogel can be administered as a fluid using a syringe and a needle, making it a unique thermosensitive, lowly invasive system. Additionally, the injectable nature of the hydrogel offers the advantages of filling small and irregular defects, and carrying therapeutic agents and cells [154]. Moreover, the hydrogel was prepared in aqueous media in absence of crosslinking agents and could become a gel at physiological $\mathtt { p H }$ and temperature. The hydrogel could make the sol-gel transition in a relatively short time, and increasing gelatin and bioactive glass content in the hydrogel imparted higher mechanical properties and shorter gelation time. The cell viability test demonstrated cytocompatibility of the hydrogel. The hydrogel could be easily expelled from a syringe and needle with the use of a moderate force of $4 . 0 \mathrm { ~ N ~ }$ . This hydrogel could bring an unexplored and innovative approach to bone tissue engineering.

However, the search for hybrid scaffolds with the required mechanical properties and biocompatibility has been ongoing. Hu et al. prepared a biomimetic calcium phosphate hybrid scaffold from nano hydroxyapatite, chitosan, chondroitin sulfate, and hyaluronic acid [146]. Chondroitin sulfate and hyaluronic acid are two polysaccharides-based natural polymers. Chondroitin sulfate is the major component of glycosaminoglycan in connective tissue [155]. Chondroitin sulfate coordinates osteoblastic cell attachment and is indirectly involved in bone homeostasis [156]. Additionally, it has the potential to promote bone regeneration in two ways. The first way is by increasing the arrangement effectiveness of the growth factor, and the second way is by controlling its signal transduction pathway [155]. So, chondroitin sulfate-incorporated scaffolds have the potential to be a great candidate for tissue engineering [157]. This scaffold exhibited improved mechanical strength which might be attributed to the addition of the HAp and the interaction between the positively charged chitosan and the negatively charged chondroitin sulfate and hyaluronic acid. The scaffold also showed good osteoblast adhesion. The results revealed that osteoblasts had adhered well to the scaffolds with a remarkable increase in number.

Carbon-based materials such as graphene [158], graphene oxide [159,160] and carbon nanotubes [161,162] have been successfully combined with chitosan for applications in bone tissue engineering. These materials can be used to reinforce organic-inorganic hybrid scaffolds because of their superb mechanical properties [163]. They also exhibit antibacterial properties because of the presence of free $\pi$ electrons and induce cell adhesion, proliferation, and differentiation. Among them, graphene oxide is prepared by the oxidation of graphite and is biocompatible because of the acquired oxygen functionalities. It shows hydrophilic characteristics because of the hydroxyl (-OH) and carboxyl (-COOH) groups [164]. Aidun et al. electrospun a ternary graphene oxide-incorporated chitosan-polycaprolactone-collagen composite scaffold [165]. As the graphene oxide ratio was increased, a minimal decrease in nanofiber diameter was observed in the scaffolds. Additionally, hydrophilicity, bioactivity of the scaffolds, and cell attachment and proliferation also increased in correspondence to an increase of graphene oxide. These results implied that this scaffold could be a promising material for bone tissue regeneration; however, longterm effects of carbon-based materials should be studied. Although chitosan-based bone tissue engineering scaffolds have been extensively studied, the search for the perfect material continues, as new methods and materials are investigated every day [166–168].

# 5.3. Intervertebral disc tissue engineering

Intervertebral disc (IVD), the largest avascular tissue of the human body, is one part of the “three-joint complex” made of fibrous cartilage [169]. These joints protect the neural anatomy of the entire spine and contribute to motion, weight bearing, and flexibility. IVD contains mostly fiber-filled hydrogels and is divided into three tissue regions. The regions are the nucleus pulposus (NP), the annulus fibrosus (AF), and the vertebral endplates (VEPs). Proteoglycan (PG) hydrogels reinforced with collagen fibers make up $9 5 \ \mathrm { w t \% }$ of the IVD [170]. The cause of IVD affliction is a degenerative process that results in a loss of proteoglycans, disorganization of the extracellular matrix architecture, tears in the IVD, generation of herniation fragments, and a loss of disc height [171]. As IVD is avascular in nature, its self-regeneration is not noteworthy; in specific, AF tissues exhibit a very limited capacity for self-repair upon injury or tearing. For a torn AF, suture fixation was among the first strategies explored (Fig. 5) [172]. Nowadays, the most popular treatment is disc excision and fusion of the adjacent vertebral bodies (VBs). But this leads to further degeneration due to altered segmental motion [173]. As a result, the treatments administered to counter IVD problems have not been satisfactory [174]. Chitosan-based materials could become a promising solution to treating IVD problems because of biodegradability, nontoxicity, cytocompatibility, and hemostatic activity [175].

An injectable suspension was developed based on chitosan and cellulose nanofibers for IVD repair and regeneration through the augmentation of the NP [176]. The placement of the implant at the injection site resulted in restoration of the viscoelastic properties of the discs that were connected to restore disc biomechanics. Additionally, the restoration or increase of the disc height suppressed or decreased back pain by avoiding nerve root compression. Another work by the same authors claimed to improve mechanical properties of the chitosanbased hydrogels by incorporating cellulose nanofiber [22]. In this work, they assessed the suitability of the biomaterials for intervertebral disc tissue engineering in ex vivo experiments using pig spine models and suggested the materials to be used as implants to restore IVD.

On a different note, a promising transparent injectable solution was developed for IVD regeneration without the need for open surgery [177]. It was a biocompatible and nontoxic hydrogel based on chitosan that was liquid at $4 ~ ^ { \circ } \mathrm { C }$ and set at $3 7 ~ ^ { \circ } \mathrm { C }$ in about $3 0 ~ \mathrm { { m i n } }$ . Moreover, it exhibited a constant storage modulus over a wide range of strain, which is like that of IVD ECM structure that could be a suitable scaffold for cells of IVD and regeneration. Other IVD tissue engineering-related work includes chitosan-based gels and temperature-responsive hydroxybutyl chitosan [178–181]. However, most of these studies were performed in in vitro conditions; extensive research is still needed before any human applications.

# 5.4. Blood vessel tissue engineering

In vascular engineering, prosthetic grafts are commonly used where cells can form functional regenerated tissue. However, its workability often becomes limited because of host cell infiltration, calcification, or poor remodeling. Vascular autografts also face issues such as size mismatch, lack of supply, or preexisting vascular diseases [182]. The grafts or patches from the biomaterial come in contact with blood and are hence required to be biocompatible. Incompatibility can lead to inflammation and calcification, and consequently post-surgical failure. The degradation of biomaterials needs to be controlled so that it neither degrades too rapidly nor too slowly. If the graft degrades too rapidly, the graft is susceptible to shape failure. If it degrades too slowly, cell proliferation and integration are hindered. So, synthesis of biomaterial grafts that can support cell infiltration and cell proliferation, and can undergo rapid remodeling is paramount for success in blood vessel tissue engineering. Chitosan is not only a biodegradable and biocompatible material; it can also be easily tuned to exhibit desired properties because of its porous and gel-forming characteristics. Furthermore, chitosan is a natural polymer of glucosamine and $N$ -acetyl glucosamine. The ECM of blood vessel tissue is made of glycosaminoglycans which have a similar structure to that of chitosan. In this context, blends of chitosan and other polymers have shown potential enhancements in mechanical strength, and cell adhesion and proliferation [183–185].

Vascular layer-by-layer patches have also been explored in which layered polymer deposition improved attachment and proliferation of cells. Layers are used because multicomponent biomaterials are often unstable and require extensive synthesis procedure. Deposition of different components is done by alternating layers of oppositely charged components [186]. In one study, bilayer chitosan-gelatin grafts were prepared with a large surface area. The inner layer accounted for good cell adhesion and proliferation whereas the outer layer gave structural flexibility and protection [187]. In other studies, researchers developed chitosan-immobilized polyethylene terephthalate films [188] and chitosan-PVA scaffolds [189] that demonstrated cell adhesion, morphology, and growth. Both materials were potential candidates for vascular tissue engineering scaffolds. The combination of chitosan and PVA improved cell attachment while maintaining the physical properties of the scaffold. Some reports demonstrated evidence of overcoming two major problems of existing small‐diameter vascular grafts: incomplete endothelialization and smooth muscle cell hyperplasia. This was accomplished by incorporating GAGs in porous chitosan scaffolds [183].

Recently, a strategy to fabricate blood vessels with high surface area-to-volume ratios by electrospinning methods has drawn the attention of many researchers. Such an attempt was made by Fiqrianti et al. where they developed a blood vessel tube with blended PLLA -chitosan-collagen electrospun fiber [190]. The tube showed improved cell viability and hemocompatibility, good tensile strength and burst pressure, and met the standards of high hemocompatibility and low cytotoxicity for vascular graft material. In recent work, Zhang et al. introduced a novel vascular patch of polyelectrolyte multilayers (PEM)

by using a layer-by-layer (LbL) self-assembly technique (Fig. 6) [186]. Chitosan and heparin were deposited onto the polyurethane-coated decellularized scaffold (PU/DCS). The in vivo and in vitro studies of these PEM vascular patches confirmed the improved biocompatibilities including decreased hemolysis rate, prolonged in vitro coagulation time, and enhanced resistance to platelet adhesion. The patches showed enhanced endothelial progenitor cell attachment and proliferation, and maintained a long-term patency of the surgical arteries. This approach opened a feasible strategy to fabricate multi-structured vascular patches.

# 5.5. Corneal regeneration

Corneal tissue engineering is an important field in biomedical engineering. Corneal epithelial cells are responsible for maintaining corneal transparency by pumping ocular fluid inside the eye. Human corneal epithelial cells cannot regenerate, therefore, the loss of epithelial cells because of aging, trauma, or disease leads to vision impairment. If the number of the cells reduce significantly, blindness occurs [191]. The World Health Organization has estimated that corneal disease, next to cataract, is one of the major causes of blindness around the world [192]. The high demand and lack of cornea donors make corneal tissue engineering for ocular cell treatment important.

The cornea is an avascular tissue that ensures optical clarity. Corneal injuries are often treated with an amniotic membrane transplant that runs the risk of infection and rejection [193]. Scaffold or membrane efficacies synthesized from chitosan, gelatin, genipin, polycaprolactone etc. are being researched in the fields of corneal tissue engineering. Chitosan is widely chosen for its biocompatibility and antiinflammatory characteristics; however, its scaffolds or membranes have drawbacks including poor mechanical strength. To enhance scaffold characteristics, like that of other tissue engineering scaffolds, polymers are blended with chitosan. Cornea tissue scaffolds should have similar mechanical and optical properties to that of the cornea and should have the capability to support cells and have high adhesion. Since optical transparency is an important criterion of corneal implants, extra precaution is needed to maintain such while selecting materials and processing methods. Scaffolds or membranes should also be flexible and resilient during surgical manipulation. Presently, the amniotic membranes that are used clinically do not have the proper thickness, degrade fast, and have issues with sterile storage [194,195].

Corneal stroma accounts for corneal thickness and is composed of collagen fibers. Keratocytes (cornea stroma cells) are distributed among these fibers. Scaffolds that can mimic the corneal stroma have been prepared and showed potential in keratocyte growth. Often, chondroitin sulfate is blended in these scaffolds to further enhance their cornea preservation but have significant effects on corneal cell cultures [196]. Corneal haze often occurs after LASIC surgery or from exposure to alkaline. A preventative approach for corneal haze, which is often caused by deep physical or chemical injuries, can be taken by using chitosan or thiolated chitosan [197].

Wang et al. synthesized a scaffold of hydroxypropyl chitosan (HPCTS), gelatin, and chondroitin sulfate by using the crosslinker 1,4- butanediol diglycidyl ether [196]. The scaffold exhibited $8 3 \mathrm { - } 8 8 \%$ light transmission values at wavelengths of visible light and was suitable for keratocyte growth on its surface. It had high water content and allowed NaCl and glucose to permeate. Later on, Ozcelik et al. prepared ultrathin chitosan-PEG hydrogel films for corneal tissue engineering that demonstrated better mechanical strength. The tensile strains and ultimate stresses were identical to those of human corneal tissue while retaining similar tensile moduli [198]. The light transmission in the visible spectrum $4 0 0 { \mathrm { - } } 7 0 0 \ \mathrm { n m }$ increased significantly $( > 9 5 \%$ optically transparent), which was above that of the human cornea (maximum ${ \sim } 9 0 \% )$ . In a more recent study, Wang et al. investigated the underlying mechanisms of corneal endothelial cell (CEC) differentiation by using chitosan/polycaprolactone (PCL) blended membranes. They found that the blended membranes were stable and acted as an effective cell culture system that provided a favorable environment for CECs in terms of ECM compositions, therefore enhancing the growth and differentiation [199]. Several such recent reports describing significant improvements in developing chitosan-based corneal scaffolds are summarized in Table 1, along with other application fields in tissue engineering. Several tests are required for these biomaterials to qualify as a corneal scaffold. Although the eye is deemed to be an immuneprivileged site, in vivo studies of the scaffolds are a must to study the cytotoxicity, degradation rate, and IOP (intraocular pressure).

# 5.6. Skin tissue engineering

To aid the healing or regeneration of skin tissues, biomaterial-based skin substitutes (grafts) and scaffolds are often used. Superficial wounds generally do not need interventions. But aided re-epithelization is important when the wound thickness is more than $^ { 1 \mathrm { \ c m } }$ because the skin cannot regrow or may scar [200]. Skin grafts from a foreign body induce irritability, antigenicity, and disease transfer. Limited donor site is another reason hindering skin substitution. Hence, preparation of scaffolds with good cell adhesion and proliferation is required in skin tissue engineering. A good scaffold should act like ECM that guides targeted cell differentiation and proliferation, and must have biocompatibility, controllable biodegradability, and the required mechanical strength [201,202]. Chitosan-based scaffolds are superior biomaterials for skin tissue engineering because they are biocompatible and biodegradable, and because they can easily be connected to other polymers via crosslinking. This crosslinking allows chitosan-based scaffolds to gain new properties like superior mechanical strength.

![](images/a288ae7cb3a4560a4e3a42d3a667d50f7e25f1aa3ed367a3d611abb752fba882.jpg)  
Fig. 4. Preparation of chitosan-polycaprolactone shish-kebab-structured scaffolds [129]. Electrospun PCL nanofibers were used as the “shish” to prompt crystal lization of well−shaped “kebabs” of chitosan-caprolactone.

Chitosan-based scaffolds show good non-immunogenicity and degrade slowly even in the presence of lysosomes. Although chitosan is cost-effective and biocompatible, it is less soluble and often does not provide adequate mechanical strength. Bilayer scaffolding is used to give chitosan scaffolds strength. While one layer gives the necessary mechanical strength, the other layer facilitates skin regeneration. The mechanical strength can be provided by polycaprolactone or its blend, and the wound dressing can be provided by the other layer containing chitosan and its blend [203]. A bilayer chitosan study in which the scaffold was prepared using casting and lyophillization showed a good potential in retaining stability [204]. A chitosan nanofibrillar scaffold can mimic the ECM and enhances cell adhesion and proliferation. When used in vitro, impressive regeneration of the dermis and epidermis layers were observed in rats [205].

Blends of different polymers such as collagen, gelatin, fibrinogen, etc. with chitosan often provide the required properties for making scaffolds for tissue engineering. Collagen is biocompatible and low in antigenicity. However, untreated collagen scaffolds quickly degrade and are mechanically weak. Chitosan and collagen -mixed scaffolds are used to prepare scaffolds for skin regeneration and burnt skin treatment [202,206,207]. In many cases, in vitro analysis showed potential biocompatibility. The addition of more components can alter its properties. The use of glutaraldehyde in the chitosan/collagen blend can increase the duration of the scaffold. One study concluded that the small addition of glutaraldehyde $( \sim 0 . 2 5 \% )$ in chitosan-collagen mixture scaffold reduced the biodegradation significantly and provided sufficient fibroblast infiltration [202]. The addition of fibrin glue with heterogeneously-structured scaffold reduces the difficulty in growing cells on the upper portion of the scaffolds [208]. Nano or micro fibrous chitosan-collagen scaffolds mimicked ECM structure. The scaffold showed good keratinocyte migration properties and re-epithelization [206].

Like collagen, gelatin is also used as a potentially viable material in skin tissue engineering. It shows good cell adhesion and growth and possesses good mechanical strength. Electrospun gelatin-chitosan nano fibrous scaffolds show potential in tissue engineering (Fig. 7) [7,209]. These electrospun scaffolds have an interconnected network that ensures good nutrient transfer. The study showed that the presence of chitosan can enhance the proliferation of cells, albeit different ratios of the materials can give different results [209]. The addition of other materials such as hyaluronic acid can greatly enhance the flexibility and water retention [210]. Furthermore, hyaluronic acid with chitosan and gelatin enables the preparation of in vitro artificial bilayer skin with viable mechanical strength [211].

Chitosan and fibrin can also be blended to get good quality scaffolds that can support angiogenensis, repair tissue, and enhance cell binding and growth [212]. Moreover, fibrins extracted from non-mammalian sources can significantly reduce the contamination or disease transmission of gelatin and collagen. One study used fibrins extracted from salmon to produce electrospun chitosan-fibrin scaffolds that showed impressive cell proliferation [213]. Membranous skin substitutes can be prepared using chitosan. Composite membranes such as chitosan-vitamin C and lactic acid membranes have been tested to induce cell growth. Other natural biopolymer blends of chitosan scaffolds include silk fibroin microfiber and chitosan, chitosan and polycaprolactone blends, etc. [20,199,214].

# 5.7. Bone tissue fixation

Every year many people suffer from various bone related diseases and bone fractures. Scientists are trying to develop processes for bone tissue fixation that are convenient for the patient and for the physician. However, complex bone structure makes the situation complicated. Throughout the last few decades, researchers have been focusing on biopolymers e.g., chitosan and their derivatives to solve the issue of bone fracture and repair. Various forms of chitosan i.e., rods, bandages, scaffolds were fabricated for this purpose [215,216]. The main reasons for choosing chitosan includes its biodegradability, biocompatibility, and non-toxicity. In addition, the ease of fabrication, and chemical modification and compatibility with other biomaterials have made chitosan a top research choice.

Hu et al. reported the fabrication of chitosan rods by using the most common in situ precipitation technique [215]. In a different study by Wang et al., thermal treatment was introduced to facilitate the selfcrosslinking of chitosan molecules through the amine group to form a network structure. The applied temperature reduced water absorption which ultimately improved the quality of prepared chitosan nails as a bone fracture fixing device [217]. A biocompatible rod was fabricated from crosslinked chitosan by using glutaraldehyde as a crosslinker for fixing bone fractures. It was also reported that crosslinked chitosan performed better than the non-crosslinked one and showed comparable mechanical properties [218]. However, in a previous study, a chitosanbased composite was fabricated by incorporating chitin fiber, which showed improved bone-like crystallinity and thermal stability. Poor mechanical properties restrict applications in the biomedical field [219].

Other than only selecting chitosan, Wang et al. used HAp as a second component, along with chitosan, to formulate a new biomaterial [220]. It is accepted that introducing HAp can improve the bioactivity of bone-repairing materials and induce neo-bone formation. Here, the raw materials were reinforced by a covalently crosslinking layer-bylayer method. The authors fabricated a non-crosslinked composite by using the same components in an equal ratio to compare with the crosslinked one and reported higher bending moduli and strength values for cross-linked samples. A recent report claimed that chitosan, either used solely or in combination with another material, performed better whenever it was crosslinked, compared to the non-crosslinked counterpart. As an implant material, a similar layer-by-layer biocompatible composite based on chitosan and HAp was fabricated by Pu et al. This composite exhibited comparable mechanical properties and cell compatibilities [221]. Unlike Wang et al., Pu et al. fabricated the composite by a in situ precipitation method [220,221].

![](images/b4739aa5b85a60fb98e92d55571429a5af94cb0be4c66163f9c770004b79e390.jpg)  
Fig. 5. Schematic image of Intervertebral disc section showing the annulus fibrosus (AF) insertion into the vertebral body and routes of nutrient transport and gas exchange. A tear in the AF (Bottom Right) and suture fixation for AF repair (Inset) [172].

![](images/7550c09a02c06418c2d3b9ccd81fa891091887813bb31a61c14b6fd6c0f95150.jpg)  
Fig. 6. Schematic depicting the preparation of a multi-structured vascular patch via a layer-by-layer self-assembly of heparin and chitosan [186].

As a bone fracture fixing material, chitosan can combine with other complex materials. Ahtiainen et al. described a knit and rolled scaffold prepared from chitosan, bioactive glass, and polylactic acid [216]. The authors claimed that the chitosan enhanced the chondrogenic differentiation compared to other scaffolds without chitosan, but they did not account for the media used. Wang et al. proposed a similar pattern of study by fabricating a hybrid material of chitosan with poly(p-aminophenylacetylene)/multi-walled carbon nanotubes impregnated by superparamagnetic $\mathrm { F e } _ { 3 } \mathrm { O } _ { 4 }$ [222]. The researchers modified the conventional technique of in situ precipitation by introducing a magnetic field. This processing helped achieve a promising bending strength and bending modulus, which are higher than that of the rods made from pure chitosan. Moreover, accelerated cell proliferation and reduction of bending stress were also recorded for this hybrid combination of chitosan [222]. Chitosan can also be used to fix fibrous materials to bone by bone ingrowth into the spaces between fibers. Kawai et al. prepared non-woven polyester fabrics coated with chitin/chitosan to evaluate the efficacy of the material as a bone formation accelerator [223]. The bone tissues surrounding the fabrics survived for prolonged periods and ensured the long-term integrity of bone-graft fixation. Moreover, a fifteenday practical experiment showed that the fixation strength and the area of bone tissue formed in the spaces between the fibers increased significantly compared to that of the control (no chitin/chitosan coating).

# 5.8. Periodontal tissue engineering

Chitosan is considered as a potential candidate for biodental applications because of its bioactivity, antimicrobial, biocompatibility, ability to blend with other materials [224]. It is as effective as a single component and in many cases, it performed better when combined with other compatible organic or inorganic materials. Starting from drug delivery, chitosan-based composites are used in enamel remineralization [225] and growth [226], dentin bonding [227], dental restorative materials [228], protective coating on dental implants [229], and so on.

However, among many dental problems, periodontal disease is one of the major concerns in medical science because it results in irreversible loss of periodontal tissues and ultimately tooth loss. The inhospitable mouth environment becomes worse in the presence of periodontitis which is a chronic inflammatory process. Hence, researchers have been searching to find a suitable biomaterial replacement.

Various forms and combinations of chitosan were studied and analyzed but very few works have been recorded in last 10 years. Many researchers used chitosan solely whereas some investigated the ability of this biopolymer to combine with other organic and inorganic materials. In both cases, the resultant material showed promising activity in biodental field. In 2008, Shen et al. used chitosan as the only primary raw material to construct crosslinked and non-crosslinked sponges [230]. Tripolyphosphate, the crosslinking agent, and tetracycline, the drug, were incorporated in both the sponges separately. Crosslinked sponges performed better than non-crosslinked ones in terms of releasing cycline and the authors recommended the material to be used for antimicrobial activity in the dental core.

Other than sponges, a chitosan-based scaffold was prepared by adding HAp beads to chitosan gels followed by loading with basic fibroblast growth factor (bFGF) [231]. The structure gave a 3D pattern which provided better cell structure, proliferation, and mineralization. The material was proposed as a device to maintain periodontal regeneration by the authors. In the same year, Peng et al. incorporated DNA in a chitosan and collagen matrix which was applied as an agent to regenerate periodontal tissue [232]. This porous chitosan/collagen matrix consisted of embedded chitosan/plasmid DNA nanoparticles encoding platelet derived growth factor. This kind of structure helped release the DNA in a steady manner for about six weeks. A two-week analysis revealed that the material was capable of initiating protein at high levels. Moreover, it also developed periodontal connective tissuelike structures [232]. A microsphere-based scaffold was developed by Soran et al., in 2012 in which the researchers electrosprayed alginate to make microspheres and later incorporated these into previously-formed chitosan gels [233]. This microsphere-scaffold system showed controlled delivery of bone morphogenetic protein-6 (BMP-6) from alginate microspheres, an effective growth factor for promoting periodontal tissue engineering [234]. Another common and cost-effective method of composite fabrication is solvent casting. Chitosan can be combined with bioactive glass nanoparticles to fabricate a membrane that can resist the movement of the epithelial cells by solvent casting [235]. This technique minimizes the transfer of the epithelial cells to the respective site, which usually hampers the production of the bones. This composite membrane could be used as a temporary guide for periodontal tissue regeneration, with the probability of inducing bone regeneration.

# 6. Prospects and recommendations

With the growing understanding of the biological response to existing bioactive materials and a better exploration of human organ composition, function, biomechanics, possible damage, and disease etiology, a multidisciplinary collaborative effort from chemists, polymer scientists, biologists, physicians, and engineers will be helpful to develop tailor-made polymers for biomedical applications. At present, chitosan is one of the most capable biopolymers for tissue engineering because of its wide availability and unique properties. However, efforts should be made to tailor scaffold properties for precise tissue requirements. To be specific, in case of cartilage, bone, and intervertebral disc tissue engineering, generating structures with predictable pore sizes and degradation rates with improved mechanical properties are crucial. A controlled freezing method can provide a simple, reproducible way of optimizing pore morphology over a physiologically relevant range. For blood vessels, deposition of platelets is one of the major challenges for their successful implication. A multistructured vascular patch using electrospun fiber of chitosan-based scaffold could be a solution. Chitosan can be combined with other biomaterials (biodegradable or bioresorbable) for boosting the applicability and bioavailability as a bone fracture repairing agents. In the last decade, very little work has focused on the area of human ear bones or nose bone repairing, where a flexible composite might prove helpful to the patient. Hence, research should be done to incorporate chitosan with other flexible biopolymers for repairing or accelerating the bone formation on these specific sites.

![](images/07199182a8eb26a074ab17acc726841a006e56b2537f5cf75a2c5fdb629722b5.jpg)  
Fig. 7. Process of fabricating electrospun scaffolds for skin tissue engineering.

Most of the research focused on the utilization of chitosan for fabricating bioactive materials; few tried with suitable derivatives. Exploring the functionality of a wide variety of available chitosan derivatives in biomaterial formulation would be a great opportunity for developing new materials with novel properties. Moreover, emphasis can be given to modify and functionalize the surface of the materials with biologically active ingredients to achieve better performance.

Previously published studies are limited to the fabrication of biomaterials and their in vitro evaluations. However, these studies could have been more useful if they had focused on in vivo applications at the same time. From Table 1, it is clear that the majority of the recent reports in this field are based on in vitro evaluations, and finding followup reports on this topic is difficult. Furthermore, many newly developed materials show good results for in vitro examination but face challenges in overcoming in vivo testing. A much more systematic approach is needed to create a strategy for developing advanced biomaterials, from fabrication to human body implantation.

# 7. Concluding remarks

Chitosan exhibits excellent physico-chemical properties and specific interactions with proteins, cells, and living organisms. The presence of primary amines along the backbone of its structure helps to form polycation (upon protonation in acidic conditions), which allows the processing of this material with various anionic polymers in a wide variety of shapes. The greatest promise to achieve extensive improvements in long-term tissue fixation, repair, and regeneration is to concentrate on research and think about creating a new generation of bioactive materials that enhance human repair mechanisms. The authors anticipate that successful use of chitosan-based bioactive materials in different tissues and organs such as skin, blood vessel, corneal, cartilage, and bone implies their promising future for fixation, repair, and regeneration applications. Utilization of chitosan-based matrices for tissue engineering can be expected to have major impact on the quality of tissue outcomes, because of its natural match in structure, chemistry, and functions to host environments. Despite recent technological advances, more research is needed to investigate the modification process to enhance cell-specific interactions, formation of morecomplex tissue structures, and the long-term biocompatibility impact of the use of these materials within the human body.

# Declaration of competing interest

Authors do not have any conflicts of interest to declare.

# Acknowledgements

This research did not receive any specific grant from funding agencies in the public, commercial, or not-for-profit sectors. We thank Mr. Philip Alarcon-Furman for assistance with English editing, and for comments that greatly improved the manuscript.

# References

[1] D.N. Coakley, F.M. Shaikh, K. O'Sullivan, E.G. Kavanagh, P.A. Grace, T.M. McGloughlin, In vitro evaluation of acellular porcine urinary bladder extracellular matrix–A potential scaffold in tissue engineered skin, Wound Med. 10 (2015) 9–16.   
[2] J. Venkatesan, R. Jayakumar, S. Anil, E.P. Chalisserry, R. Pallela, S.-K. Kim, Development of alginate-chitosan-collagen based hydrogels for tissue engineering, J. Biomater. Tissue Eng. 5 (6) (2015) 458–464.   
[3] G. Guan, L. Bai, B. Zuo, M. Li, Z. Wu, Y. Li, L. Wang, Promoted dermis healing from full-thickness skin defect by porous silk fibroin scaffolds (PSFSs), Bio Med. Mater. Eng. 20 (5) (2010) 295–308.   
[4] X. Garric, O. Guillaume, H. Dabboue, M. Vert, J.-P. Molès, Potential of a PLA–PEO–PLA-based scaffold for skin tissue engineering: in vitro evaluation, J. Biomater. Sci. Polym. Ed. 23 (13) (2012) 1687–1700.   
[5] E.J. Chong, T.T. Phan, I.J. Lim, Y. Zhang, B.H. Bay, S. Ramakrishna, C.T. Lim, Evaluation of electrospun PCL/gelatin nanofibrous scaffold for wound healing and layered dermal reconstitution, Acta Biomater. 3 (3) (2007) 321–330.   
[6] A. Al-Mamun, P. Haque, T. Debnath, M.F. Rahman, J.M. Islam, M.M. Rahman, M.A. Khan, γ-Irradiated gelatin and polyvinyl alcohol films as artificial articular cartilage, J. Thermoplast. Compos. Mater. (2018) 1–14, https://doi.org/10.1177/ 0892705718808555.   
[7] Y. Huang, S. Onyeri, M. Siewe, A. Moshfeghian, S.V. Madihally, In vitro characterization of chitosan–gelatin scaffolds for tissue engineering, Biomaterials 26 (36) (2005) 7616–7627.   
[8] V. Sencadas, D.M. Correia, C. Ribeiro, S. Moreira, G. Botelho, J.G. Ribelles, S. Lanceros-Méndez, Physical-chemical properties of cross-linked chitosan electrospun fiber mats, Polym. Test. 31 (8) (2012) 1062–1069.   
[9] Z. Gu, H. Xie, C. Huang, L. Li, X. Yu, Preparation of chitosan/silk fibroin blending membrane fixed with alginate dialdehyde for wound dressing, Int. J. Biol. Macromol. 58 (2013) 121–126.   
[10] E.M. Ivan'kova, I.P. Dobrovolskaya, P.V. Popryadukhin, A. Kryukov, V.E. Yudin, P. Morganti, In-situ cryo-SEM investigation of porous structure formation of chitosan sponges, Polym. Test. 52 (2016) 41–45.   
[11] M.S. Islam, P. Haque, T.U. Rashid, M.N. Khan, A.K. Mallik, M.N.I. Khan, M. Khan, M.M. Rahman, Core–shell drug carrier from folate conjugated chitosan obtained from prawn shell for targeted doxorubicin delivery, J. Mater. Sci. Mater. Med. 28 (4) (2017) 55.   
[12] M.M. Rahman, M. Shahruzzaman, M.S. Islam, M.N. Khan, P. Haque, Preparation and properties of biodegradable polymer/nano-hydroxyapatite bioceramic scaffold for spongy bone regeneration, J. Polym. Eng. 39 (2) (2019) 134–142.   
[13] A.R. Amini, C.T. Laurencin, S.P. Nukavarapu, Bone tissue engineering: recent advances and challenges, Crit. Rev. Biomed. Eng. 40 (5) (2012).   
[14] K. Balagangadharan, S. Dhivya, N. Selvamurugan, Chitosan based nanofibers in

bone tissue engineering, Int. J. Biol. Macromol. 104 (2017) 1372–1382. [15] R. LogithKumar, A. KeshavNarayan, S. Dhivya, A. Chawla, S. Saravanan, N. Selvamurugan, A review of chitosan and its derivatives in bone tissue engineering, Carbohydr. Polym. 151 (2016) 172–188. [16] S. Saravanan, R. Leena, N. Selvamurugan, Chitosan based biocomposite scaffolds for bone tissue engineering, Int. J. Biol. Macromol. 93 (2016) 1354–1365. [17] R. Leena, M. Vairamani, N. Selvamurugan, Alginate/Gelatin scaffolds incorporated with Silibinin-loaded Chitosan nanoparticles for bone formation in vitro, Colloids Surf. B Biointerfaces 158 (2017) 308–318. [18] S. Deepthi, J. Venkatesan, S.-K. Kim, J.D. Bumgardner, R. Jayakumar, An overview of chitin or chitosan/nano ceramic composite scaffolds for bone tissue engineering, Int. J. Biol. Macromol. 93 (2016) 1338–1353. [19] R. Arun Kumar, A. Sivashanmugam, S. Deepthi, S. Iseki, K. Chennazhi, S.V. Nair, R. Jayakumar, Injectable chitin-poly (ε-caprolactone)/nanohydroxyapatite composite microgels prepared by simple regeneration technique for bone tissue engineering, ACS Appl. Mater. Interfaces 7 (18) (2015) 9399–9409. [20] X. Zhang, C. Jia, X. Qiao, T. Liu, K. Sun, Silk fibroin microfibers and chitosan modified poly (glycerol sebacate) composite scaffolds for skin tissue engineering, Polym. Test. 62 (2017) 88–95. [21] F. Hildner, C. Albrecht, C. Gabriel, H. Redl, M. Van Griensven, State of the art and future perspectives of articular cartilage regeneration: a focus on adipose‐derived stem cells and platelet‐derived products, J. Tissue Eng. Regen. Med. 5 (4) (2011) e36–e51. [22] I. Doench, T.A. Tran, L. David, A. Montembault, E. Viguier, C. Gorzelanny, G. Sudre, T. Cachon, M. Louback-Mohamed, N. Horbelt, Cellulose nanofiber-reinforced chitosan hydrogel composites for intervertebral disc tissue repair, Biomimetics 4 (1) (2019) 19. [23] M.N.R. Kumar, A review of chitin and chitosan applications, React. Funct. Polym. 46 (1) (2000) 1–27. [24] Q. Li, E. Dunn, E. Grandmaison, M.F. Goosen, Applications and properties of chitosan, J. Bioact. Compat Polym. 7 (4) (1992) 370–397. [25] A. Tolaimate, J. Desbrieres, M. Rhazi, A. Alagui, Contribution to the preparation of chitins and chitosans with controlled physico-chemical properties, Polymer 44 (26) (2003) 7939–7952. [26] T.U. Rashid, M.M. Rahman, S. Kabir, S.M. Shamsuddin, M.A. Khan, A new approach for the preparation of chitosan from γ‐irradiation of prawn shell: effects of radiation on the characteristics of chitosan, Polym. Int. 61 (8) (2012) 1302–1308. [27] S. Kumari, P.K. Rath, Extraction and characterization of chitin and chitosan from (Labeo rohit) fish scales, Procedia Mater. Sci. 6 (2014) 482–489. [28] P. Methacanon, M. Prasitsilp, T. Pothsree, J. Pattaraarchachai, Heterogeneous Ndeacetylation of squid chitin in alkaline solution, Carbohydr. Polym. 52 (2) (2003) 119–123. [29] A. Pelletier, I. Lemire, J. Sygusch, E. Chornet, R.P. Overend, Chitin/chitosan transformation by thermo‐mechano‐chemical treatment including characterization by enzymatic depolymerization, Biotechnol. Bioeng. 36 (3) (1990) 310–315. [30] B. Focher, P. Beltrame, A. Naggi, G. Torri, Alkaline N-deacetylation of chitin enhanced by flash treatments. Reaction kinetics and structure modifications, Carbohydr. Polym. 12 (4) (1990) 405–418. [31] A. Domard, G.A. Roberts, K.M. Varum, Advances in Chitin Science, Domard, A, 1997, p. 410. [32] T. Lertwattanaseri, N. Ichikawa, T. Mizoguchi, Y. Tanaka, S. Chirachanchai, Microwave technique for efficient deacetylation of chitin nanowhiskers to a chitosan nanoscaffold, Carbohydr. Res. 344 (3) (2009) 331–335. [33] I. Aranaz, M. Mengíbar, R. Harris, I. Paños, B. Miralles, N. Acosta, G. Galed, Á. Heras, Functional characterization of chitin and chitosan, Curr. Chem. Biol. 3 (2) (2009) 203–230. [34] S. Mima, M. Miya, R. Iwamoto, S. Yoshikawa, Highly deacetylated chitosan and its properties, J. Appl. Polym. Sci. 28 (6) (1983) 1909–1917. [35] M.M. Rahman, T.U. Rashid, Impact of high energy irradiation on chitin and chitosan: a short review, in: G. Sisto (Ed.), Crustaceans: Structure, Ecology and Life Cycle, Nova Science Publishers, Inc., NY,USA., 2013, pp. 37–70. [36] M.M. Rahman, S. Kabir, T.U. Rashid, B. Nesa, R. Nasrin, P. Haque, M.A. Khan, Effect of $\gamma$ -irradiation on the thermomechanical and morphological properties of chitosan obtained from prawn shell: evaluation of potential for irradiated chitosan as plant growth stimulator for Malabar spinach, Radiat. Phys. Chem. 82 (2013) 112–118. [37] M.E.A. Ali, M.M.S. Aboelfadl, A.M. Selim, H.F. Khalil, G.M. Elkady, Chitosan nanoparticles extracted from shrimp shells, application for removal of Fe (II) and Mn (II) from aqueous phases, Separ. Sci. Technol. 53 (18) (2018) 2870–2881. [38] M.M. Rahman, T.U. Rashid, A. Datta, Chitosan: Process and Modification, Encyclopedia of Biomedical Polymers and Polymeric Biomaterials 11 Volume Set CRC Press, 2015, pp. 1811–1825. [39] S.-i. Park, Y. Zhao, Incorporation of a high concentration of mineral or vitamin into chitosan-based films, J. Agric. Food Chem. 52 (7) (2004) 1933–1939. [40] M.R. Leedy, H.J. Martin, P.A. Norowski, J.A. Jennings, W.O. Haggard, J.D. Bumgardner, Use of Chitosan as a Bioactive Implant Coating for Bone-Implant Applications, Chitosan for biomaterials II, Springer, 2011, pp. 129–165. [41] S. Dey, M. Al-Amin, T. Rashid, M. Ashaduzzaman, S. Shamsuddin, pH induced fabrication of kaolinite-chitosan biocomposite, Int. Lett. Chem. Phys. Astron. 68 (2016) 1–9. [42] M. Rinaudo, Chitin and chitosan: properties and applications, Prog. Polym. Sci. 31 (7) (2006) 603–632. [43] T.U. Rashid, S.M. Shamsuddin, M.A. Khan, M.M. Rahman, Evaluation of fat binding capacity of gamma irradiated chitosan extracted from prawn shell, Soft Mater. 12 (3) (2014) 262–267. [44] L. Hench, J. Jones, Biomaterials, Artificial Organs and Tissue Engineering,

Elsevier, 2005.   
[45] P. Habibovic, K. de Groot, Osteoinductive biomaterials—properties and relevance in bone repair, J. Tissue Eng. Regen. Med. 1 (1) (2007) 25–32.   
[46] A. Barradas, H. Yuan, C.A. van Blitterswijk, P. Habibovic, Osteoinductive biomaterials: current knowledge of properties, experimental models and biological mechanisms, Eur. Cell. Mater. 21 (407) (2011) 29.   
[47] I.-Y. Kim, S.-J. Seo, H.-S. Moon, M.-K. Yoo, I.-Y. Park, B.-C. Kim, C.-S. Cho, Chitosan and its derivatives for tissue engineering applications, Biotechnol. Adv. 26 (1) (2008) 1–21.   
[48] S. Stratton, N.B. Shelke, K. Hoshino, S. Rudraiah, S.G. Kumbar, Bioactive polymeric scaffolds for tissue engineering, Bioact. Mater. 1 (2) (2016) 93–108.   
[49] P. Lee, K. Tran, G. Zhou, A. Bedi, N.B. Shelke, X. Yu, S.G. Kumbar, Guided differentiation of bone marrow stromal cells on co-cultured cartilage and bone scaffolds, Soft Matter 11 (38) (2015) 7648–7655.   
[50] J.C. Middleton, A.J. Tipton, Synthetic biodegradable polymers as orthopedic devices, Biomaterials 21 (23) (2000) 2335–2346.   
[51] S. Kumbar, C. Laurencin, M. Deng, Natural and Synthetic Biomedical Polymers, Newnes, 2014.   
[52] B. Dhandayuthapani, Y. Yoshida, T. Maekawa, D.S. Kumar, Polymeric scaffolds in tissue engineering application: a review, Int. J. Polym. Sci. 2011 (2011).   
[53] Q. Hu, B. Li, M. Wang, J. Shen, Preparation and characterization of biodegradable chitosan/hydroxyapatite nanocomposite rods via in situ hybridization: a potential material as internal fixation of bone fracture, Biomaterials 25 (5) (2004) 779–785.   
[54] R. Nasrin, S. Biswas, T.U. Rashid, S. Afrin, R.A. Jahan, P. Haque, M.M. Rahman, Preparation of Chitin-PLA laminated composite for implantable application, Bioact. Mater. 2 (4) (2017) 199–207.   
[55] C. Aimin, H. Chunlin, B. Juliang, Z. Tinyin, D. Zhichao, Antibiotic loaded chitosan bar: an in vitro, in vivo study of a possible treatment for osteomyelitis, Clin. Orthop. Relat. Res. 366 (1999) 239–247.   
[56] M. Morille, T. Van-Thanh, X. Garric, J. Cayon, J. Coudane, D. Noël, M.-C. VenierJulienne, C.N. Montero-Menei, New PLGA–P188–PLGA matrix enhances TGF-β3 release from pharmacologically active microcarriers and promotes chondrogenesis of mesenchymal stem cells, J. Contr. Release 170 (1) (2013) 99–110.   
[57] M. Dash, F. Chiellini, R.M. Ottenbrite, E. Chiellini, Chitosan—a versatile semisynthetic polymer in biomedical applications, Prog. Polym. Sci. 36 (8) (2011) 981–1014.   
[58] G. Balasundaram, D.M. Storey, T.J. Webster, Novel nano-rough polymers for cartilage tissue engineering, Int. J. Nanomed. 9 (2014) 1845.   
[59] L. Kock, C.C. van Donkelaar, K. Ito, Tissue engineering of functional articular cartilage: the current status, Cell Tissue Res. 347 (3) (2012) 613–627.   
[60] A. Muxika, A. Etxabide, J. Uranga, P. Guerrero, K. De La Caba, Chitosan as a bioactive polymer: processing, properties and applications, Int. J. Biol. Macromol. 105 (2017) 1358–1368.   
[61] Z. Shariatinia, A.M. Jalali, Chitosan-based hydrogels: preparation, properties and applications, Int. J. Biol. Macromol. 115 (2018) 194–220.   
[62] P. Domalik-Pyzik, J. Chłopek, K. Pielichowska, Chitosan-Based Hydrogels: Preparation, Properties, and Applications, Cellulose-Based Superabsorbent Hydrogels, (2019), pp. 1665–1693.   
[63] J.-K.F. Suh, H.W. Matthew, Application of chitosan-based polysaccharide biomaterials in cartilage tissue engineering: a review, Biomaterials 21 (24) (2000) 2589–2598.   
[64] S.C. Neves, L.S.M. Teixeira, L. Moroni, R.L. Reis, C.A. Van Blitterswijk, N.M. Alves, M. Karperien, J.F. Mano, Chitosan/Poly (ϵ-caprolactone) blend scaffolds for cartilage repair, Biomaterials 32 (4) (2011) 1068–1079.   
[65] M.A. Shamekhi, H. Mirzadeh, H. Mahdavi, A. Rabiee, D. Mohebbi-Kalhori, M.B. Eslaminejad, Graphene oxide containing chitosan scaffolds for cartilage tissue engineering, Int. J. Biol. Macromol. 127 (2019) 396–405.   
[66] M. Kashi, F. Baghbani, F. Moztarzadeh, H. Mobasheri, E. Kowsari, Green synthesis of degradable conductive thermosensitive oligopyrrole/chitosan hydrogel intended for cartilage tissue engineering, Int. J. Biol. Macromol. 107 (2018) 1567–1575.   
[67] C.-Y. Kuo, C.-H. Chen, C.-Y. Hsiao, J.-P. Chen, Incorporation of chitosan in biomimetic gelatin/chondroitin-6-sulfate/hyaluronan cryogel for cartilage tissue engineering, Carbohydr. Polym. 117 (2015) 722–730.   
[68] Z.-S. Shen, X. Cui, R.-X. Hou, Q. Li, H.-X. Deng, J. Fu, Tough biodegradable chitosan–gelatin hydrogels via in situ precipitation for potential cartilage tissue engineering, RSC Adv. 5 (69) (2015) 55640–55647.   
[69] W. Xia, W. Liu, L. Cui, Y. Liu, W. Zhong, D. Liu, J. Wu, K. Chua, Y. Cao, Tissue engineering of cartilage with the use of chitosan‐gelatin complex scaffolds, J. Biomed. Mater. Res. Part B: Applied Biomaterials: An Official Journal of The Society for Biomaterials, The Japanese Society for Biomaterials, and The Australian Society for Biomaterials and the Korean Society for Biomaterials 71 (2) (2004) 373–380.   
[70] T.U. Rashid, S. Sharmeen, S. Biswas, T. Ahmed, A.K. Mallik, M. Shahruzzaman, M. Nurus Sakib, P. Haque, M.M. Rahman, Gelatin-based hydrogels, CelluloseBased Superabsorbent Hydrogels, (2018), pp. 1–41.   
[71] B. Young, W. Pitt, S. Cooper, Protein adsorption on polymeric biomaterials I. Adsorption isotherms, J. Colloid Interface Sci. 124 (1) (1988) 28–43.   
[72] L.P. Yan, Y.J. Wang, L. Ren, G. Wu, S.G. Caridade, J.B. Fan, L.Y. Wang, P.H. Ji, J.M. Oliveira, J.T. Oliveira, Genipin‐cross‐linked collagen/chitosan biomimetic scaffolds for articular cartilage tissue engineering applications, J. Biomed. Mater. Res. 95 (2) (2010) 465–475.   
[73] A. Kaviani, S.M. Zebarjad, S. Javadpour, M. Ayatollahi, R. Bazargan-Lari, Fabrication and characterization of low-cost freeze-gelated chitosan/collagen/ hydroxyapatite hydrogel nanocomposite scaffold, Int. J. Polym. Anal. Char. 24 (3)   
[74] T. Minas, S. Nehrer, Current concepts in the treatment of articular cartilage defects, Orthopedics 20 (6) (1997) 525–538.   
[75] K. Thunsiri, A. Oonjai, W. Wattanutchariya, Characterization of Hydroxyapatite/ Silk Fibroin/Chitosan Scaffold for Cartilage Tissue Engineering, Key Engineering Materials, Trans Tech Publ, 2018, pp. 120–126.   
[76] S. Chameettachal, S. Murab, R. Vaid, S. Midha, S. Ghosh, Effect of visco‐elastic silk–chitosan microcomposite scaffolds on matrix deposition and biomechanical functionality for cartilage tissue engineering, J. Tissue Eng. Regen. Med. 11 (4) (2017) 1212–1229.   
[77] V. Vishwanath, K. Pramanik, A. Biswas, Optimization and evaluation of silk fibroin-chitosan freeze-dried porous scaffolds for cartilage tissue engineering application, J. Biomater. Sci. Polym. Ed. 27 (7) (2016) 657–674.   
[78] B. Singh, K. Pramanik, Fabrication and evaluation of non-mulberry silk fibroin fiber reinforced chitosan based porous composite scaffold for cartilage tissue engineering, Tissue Cell 55 (2018) 83–90.   
[79] K. Panjapheree, S. Kamonmattayakul, J. Meesane, Biphasic scaffolds of silk fibroin film affixed to silk fibroin/chitosan sponge based on surgical design for cartilage defect in osteoarthritis, Mater. Des. 141 (2018) 323–332.   
[80] N.R. Raia, B.P. Partlow, M. McGill, E.P. Kimmerling, C.E. Ghezzi, D.L. Kaplan, Enzymatically crosslinked silk-hyaluronic acid hydrogels, Biomaterials 131 (2017) 58–67.   
[81] B.B. Mandal, S. Kundu, A novel method for dissolution and stabilization of non‐- mulberry silk gland protein fibroin using anionic surfactant sodium dodecyl sulfate, Biotechnol. Bioeng. 99 (6) (2008) 1482–1489.   
[82] S.-M. Lien, L.-Y. Ko, T.-J. Huang, Effect of pore size on ECM secretion and cell growth in gelatin scaffold for articular cartilage tissue engineering, Acta Biomater. 5 (2) (2009) 670–679.   
[83] Y. Tamada, Y. Ikada, Cell adhesion to plasma-treated polymer surfaces, Polymer 34 (10) (1993) 2208–2212.   
[84] T. Li, X. Song, C. Weng, X. Wang, L. Gu, X. Gong, Q. Wei, X. Duan, L. Yang, C. Chen, Silk fibroin/carboxymethyl chitosan hydrogel with tunable biomechanical properties has application potential as cartilage scaffold, Int. J. Biol. Macromol. 137 (2019) 382–391.   
[85] J. Liu, B. Yang, M. Li, J. Li, Y. Wan, Enhanced dual network hydrogels consisting of thiolated chitosan and silk fibroin for cartilage tissue engineering, Carbohydr. Polym. (2019) 115335.   
[86] Y. Zhou, K. Liang, S. Zhao, C. Zhang, J. Li, H. Yang, X. Liu, X. Yin, D. Chen, W. Xu, Photopolymerized maleilated chitosan/methacrylated silk fibroin micro/nanocomposite hydrogels as potential scaffolds for cartilage tissue engineering, Int. J. Biol. Macromol. 108 (2018) 383–390.   
[87] L. Upadhyaya, J. Singh, V. Agarwal, R.P. Tewari, The implications of recent advances in carboxymethyl chitosan based targeted drug delivery and tissue engineering applications, J. Contr. Release 186 (2014) 54–87.   
[88] K. Luo, Y. Yang, Z. Shao, Physically crosslinked biocompatible silk‐fibroin‐based hydrogels with high mechanical performance, Adv. Funct. Mater. 26 (6) (2016) 872–880.   
[89] P.S. Alemi, S.A. Atyabi, F. Sharifi, M. Mohamadali, S. Irani, H. Bakhshi, S.M. Atyabi, Synergistic effect of pressure cold atmospheric plasma and carboxymethyl chitosan to mesenchymal stem cell differentiation on PCL/CMC nanofibers for cartilage tissue engineering, Polym. Adv. Technol. 30 (6) (2019) 1356–1364.   
[90] L. Lao, H. Tan, Y. Wang, C. Gao, Chitosan modified poly (L-lactide) microspheres as cell microcarriers for cartilage tissue engineering, Colloids Surf. B Biointerfaces 66 (2) (2008) 218–225.   
[91] H. Wu, Y. Wan, X. Cao, Q. Wu, Proliferation of chondrocytes on porous poly (DLlactide)/chitosan scaffolds, Acta Biomater. 4 (1) (2008) 76–87.   
[92] A. Subramanian, D. Vu, G.F. Larsen, H.-Y. Lin, Preparation and evaluation of the electrospun chitosan/PEO fibers for potential applications in cartilage tissue engineering, J. Biomater. Sci. Polym. Ed. 16 (7) (2005) 861–873.   
[93] Y.C. Kuo, Y.R. Hsu, Tissue‐engineered polyethylene oxide/chitosan scaffolds as potential substitutes for articular cartilage, J. Biomed. Mater. Res. Part A: Off. J. Soc. Biomater. Jpn. Soc. Biomater. Aust. Soc. Biomater. Kor. Soc. Biomater. 91 (1) (2009) 277–287.   
[94] H. Tan, J. Wu, L. Lao, C. Gao, Gelatin/chitosan/hyaluronan scaffold integrated with PLGA microspheres for cartilage tissue engineering, Acta Biomater. 5 (1) (2009) 328–337.   
[95] S.P. Mallick, K. Pal, A. Rastogi, P. Srivastava, Evaluation of poly (L-lactide) and chitosan composite scaffolds for cartilage tissue regeneration, Des. Monomers Polym. 19 (3) (2016) 271-282.   
[96] S.P. Mallick, B.N. Singh, A. Rastogi, P. Srivastava, Design and evaluation of chitosan/poly (L-lactide)/pectin based composite scaffolds for cartilage tissue regeneration, Int. J. Biol. Macromol. 112 (2018) 909–920.   
[97] S. Keikhaei, Z. Mohammadalizadeh, S. Karbasi, A. Salimi, Evaluation of the effects of $\beta$ -tricalcium phosphate on physical, mechanical and biological properties of poly (3-hydroxybutyrate)/chitosan electrospun scaffold for cartilage tissue engineering applications, Mater. Technol. (2019) 1–11.   
[98] I. Aranaz, E. Martínez-Campos, C. Moreno-Vicente, A. Civantos, S. GarcíaArguelles, F. del Monte, Macroporous calcium phosphate/chitosan composites prepared via unidirectional ice segregation and subsequent freeze-drying, Materials 10 (5) (2017) 516.   
[99] H. Liu, Chitosan/hydroxyapatite composite scaffolds for articular cartilage injury, Chin. J. Tissue Eng. Res. 21 (2) (2017) 244–248.   
[100] B. Subia, J. Kundu, S. Kundu, Biomaterial scaffold fabrication techniques for potential tissue engineering applications, Tissue Eng. 141 (2010).   
[101] T. Subbiah, G.S. Bhat, R.W. Tock, S. Parameswaran, S.S. Ramkumar, Electrospinning of nanofibers, J. Appl. Polym. Sci. 96 (2) (2005) 557–569.   
[102] S. Karbasi, Z.M. Alizadeh, Effects of multi-wall carbon nanotubes on structural and mechanical properties of poly (3-hydroxybutyrate)/chitosan electrospun scaffolds for cartilage tissue engineering, Bull. Mater. Sci. 40 (6) (2017) 1247–1253.   
[103] C. Liu, D. Liu, Y. Wang, Y. Li, T. Li, Z. Zhou, Z. Yang, J. Wang, Q. Zhang, Glycol chitosan/oxidized hyaluronic acid hydrogels functionalized with cartilage extracellular matrix particles and incorporating BMSCs for cartilage repair, Artificial cells, Artif. Cells Nanomed. Biotechnol. 46 (sup1) (2018) 721–732.   
[104] N. Mohan, P. Mohanan, A. Sabareeswaran, P. Nair, Chitosan-hyaluronic acid hydrogel for cartilage repair, Int. J. Biol. Macromol. 104 (2017) 1936–1945.   
[105] L. Cao, F. Zhang, Q. Wang, X. Wu, Fabrication of chitosan/graphene oxide polymer nanofiber and its biocompatibility for cartilage tissue engineering, Mater. Sci. Eng. C 79 (2017) 697–701.   
[106] M.H. Mirmusavi, P. Zadehnajar, D. Semnani, S. Karbasi, F. Fekrat, F. Heidari, Evaluation of physical, mechanical and biological properties of poly 3-hydroxybutyrate-chitosan-multiwalled carbon nanotube/silk nano-micro composite scaffold for cartilage tissue engineering applications, Int. J. Biol. Macromol. 132 (2019) 822–835.   
[107] Z. Mohammadalizadeh, S. Karbasi, S. Arasteh, Physical, mechanical and biological evaluation of poly (3-hydroxybutyrate)-chitosan/MWNTs as a novel electrospun scaffold for cartilage tissue engineering applications, Polym. Plast. Technol. Mater. (2019) 1–13.   
[108] C. Li, K. Wang, X. Zhou, T. Li, Y. Xu, L. Qiang, M. Peng, Y. Xu, L. Xie, C. He, Controllable fabrication of hydroxybutyl chitosan/oxidized chondroitin sulfate hydrogels by 3D bioprinting technique for cartilage tissue engineering, Biomed. Mater. (2018).   
[109] M.N. Rodrigues, M.B. Oliveira, R.R. Costa, J.o.F. Mano, Chitosan/chondroitin sulfate membranes produced by polyelectrolyte complexation for cartilage engineering, Biomacromolecules 17 (6) (2016) 2178–2188.   
[110] M. Prabaharan, P. Sivashankari, Prospects of Bioactive Chitosan-Based Scaffolds in Tissue Engineering and Regenerative Medicine, Chitin and Chitosan for Regenerative Medicine, Springer, 2016, pp. 41–59.   
[111] M.M. Islam, S. Biswas, M.M. Hasan, P. Haque, S.H. Rimu, M.M. Rahman, Studies of Cr (VI) adsorption on novel jute cellulose-kaolinite clay biocomposite, Desalination Water Treat. 123 (2018) 265–276.   
[112] S. Biswas, M.M. Islam, M. Hasan, S. Rimu, M. Khan, P. Haque, M. Rahman, Evaluation of Cr (VI) ion removal from aqueous solution by bio-inspired chitosanclay composite: kinetics and isotherms, Iran. J. Chem. Eng. 15 (4) (2018).   
[113] L. Kong, Y. Gao, W. Cao, Y. Gong, N. Zhao, X. Zhang, Preparation and characterization of nano‐hydroxyapatite/chitosan composite scaffolds, J. Biomed. Mater. Res. Part A: Off. J. Soc. Biomater. Jpn. Soc. Biomater. Aust. Soc. Biomater. Kor. Soc. Biomater. 75 (2) (2005) 275–282.   
[114] J. Venkatesan, S.-K. Kim, Chitosan composites for bone tissue engineering—an overview, Mar. Drugs 8 (8) (2010) 2252–2266.   
[115] B. Li, Q. Hu, X. Qian, Z. Fang, J. Shen, Bioabsorbable chitosan/hydroxyapatite composite rod prepared by in situ precipitation for internal fixation of bone fracture, Acta Polym. Sin. (6) (2002) 828–833.   
[116] J. Kozlowska, N. Stachowiak, A. Sionkowska, Preparation and characterization of collagen/chitosan poly (ethylene glycol)/nanohydroxyapatite composite scaffolds, Polym. Adv. Technol. 30 (3) (2019) 799–803.   
[117] S. Kar, T. Kaur, A. Thirugnanam, Microwave-assisted synthesis of porous chitosan–modified montmorillonite–hydroxyapatite composite scaffolds, Int. J. Biol. Macromol. 82 (2016) 628–636.   
[118] M.M. Islam, M.N. Khan, S. Biswas, T.R. Choudhury, P. Haque, T.U. Rashid, M.M. Rahman, Preparation and characterization of bijoypur clay-crystalline cellulose composite for application as an adsorbent, Adv. Mater. Sci. 2 (2017) 1–7.   
[119] J.O. Hollinger, T.A. Einhorn, B. Doll, C. Sfeir, Bone Tissue Engineering, CRC press, 2004.   
[120] A. Bhowmick, T. Mitra, A. Gnanamani, M. Das, P.P. Kundu, Development of biomimetic nanocomposites as bone extracellular matrix for human osteoblastic cells, Carbohydr. Polym. 141 (2016) 82–91.   
[121] A. Bhowmick, S.L. Banerjee, N. Pramanik, P. Jana, T. Mitra, A. Gnanamani, M. Das, P.P. Kundu, Organically modified clay supported chitosan/hydroxyapatite-zinc oxide nanocomposites with enhanced mechanical and biological properties for the application in bone tissue engineering, Int. J. Biol. Macromol. 106 (2018) 11–19.   
[122] G.E. Friedlaender, S. Lin, L.A. Solchaga, L.B. Snel, S.E. Lynch, The role of recombinant human platelet-derived growth factor-BB (rhPDGF-BB) in orthopaedic bone repair and regeneration, Curr. Pharmaceut. Des. 19 (19) (2013) 3384–3390.   
[123] L. Luca, A.-L. Rougemont, B.H. Walpoth, R. Gurny, O. Jordan, The effects of carrier nature and pH on rhBMP-2-induced ectopic bone formation, J. Contr. Release 147 (1) (2010) 38–44.   
[124] P. Marie, P. Ammann, G. Boivin, C. Rey, Mechanisms of action and therapeutic potential of strontium in bone, Calcif. Tissue Int. 69 (3) (2001) 121–129.   
[125] Y. Lei, Z. Xu, Q. Ke, W. Yin, Y. Chen, C. Zhang, Y. Guo, Strontium hydroxyapatite/ chitosan nanohybrid scaffolds with enhanced osteoinductivity for bone tissue engineering, Mater. Sci. Eng. C 72 (2017) 134–142.   
[126] I.C. Pereira, A.S. Duarte, A.S. Neto, J. Ferreira, Chitosan and polyethylene glycol based membranes with antibacterial properties for tissue regeneration, Mater. Sci. Eng. C 96 (2019) 606–615.   
[127] M. Shakir, R. Jolly, M.S. Khan, N.e. Iram, T.K. Sharma, S.I. Al‐Resayes, Synthesis and characterization of a nano‐hydroxyapatite/chitosan/polyethylene glycol nanocomposite for bone tissue engineering, Polym. Adv. Technol. 26 (1) (2015) 41–48.   
[128] A. Ghaee, J. Nourmohammadi, P. Danesh, Novel chitosan-sulfonated chitosanpolycaprolactone-calcium phosphate nanocomposite scaffold, Carbohydr. Polym. 157 (2017) 695–703.   
[129] X. Jing, H.-Y. Mi, X.-C. Wang, X.-F. Peng, L.-S. Turng, Shish-kebab-structured poly (ε-caprolactone) nanofibers hierarchically decorated with chitosan–poly (ε-caprolactone) copolymers for bone tissue engineering, ACS Appl. Mater. Interfaces 7 (12) (2015) 6955–6965.   
[130] W. Pon-On, P. Suntornsaratoon, N. Charoenphandhu, J. Thongbunchoo, N. Krishnamra, I.M. Tang, Synthesis and investigations of mineral ions-loaded apatite from fish scale and PLA/chitosan composite for bone scaffolds, Mater. Lett. 221 (2018) 143–146.   
[131] A. Rogina, L. Pribolšan, A. Hanžek, L. Gόmez-Estrada, G.G. Ferrer, I. Marijanović, M. Ivanković, H. Ivanković, Macroporous poly (lactic acid) construct supporting the osteoinductive porous chitosan-based hydrogel for bone tissue engineering, Polymer 98 (2016) 172–181.   
[132] W. Cui, Y. Zhou, J. Chang, Electrospun nanofibrous materials for tissue engineering and drug delivery, Sci. Technol. Adv. Mater. 11 (1) (2010) 014108.   
[133] J. Venugopal, L. Ma, T. Yong, S. Ramakrishna, In vitro study of smooth muscle cells on polycaprolactone and collagen nanofibrous matrices, Cell Biol. Int. 29 (10) (2005) 861–867.   
[134] I. Hide, A. Gangi, Percutaneous vertebroplasty: history, technique and current perspectives, Clin. Radiol. 59 (6) (2004) 461–467.   
[135] S. Aghyarian, E. Bentley, T.N. Hoang, I.M. Gindri, V. Kosmopoulos, H.K. Kim, D.C. Rodrigues, In vitro and in vivo characterization of premixed PMMA-cap composite bone cements, ACS Biomater. Sci. Eng. 3 (10) (2017) 2267–2277.   
[136] F. Ganji, M. Abdekhodaie, Synthesis and characterization of a new thermosensitive chitosan–PEG diblock copolymer, Carbohydr. Polym. 74 (3) (2008) 435–441.   
[137] K. Cai, K. Yao, Y. Cui, Z. Yang, X. Li, H. Xie, T. Qing, L. Gao, Influence of different surface modification treatments on poly (D, L-lactic acid) with silk fibroin and their effects on the culture of osteoblast in vitro, Biomaterials 23 (7) (2002) 1603–1611.   
[138] B. Feng, H. Tu, H. Yuan, H. Peng, Y. Zhang, Acetic-acid-mediated miscibility toward electrospinning homogeneous composite nanofibers of GT/PCL, Biomacromolecules 13 (12) (2012) 3917–3925.   
[139] X. Jing, M.R. Salick, T. Cordie, H.-Y. Mi, X.-F. Peng, L.-S. Turng, Electrospinning homogeneous nanofibrous poly (propylene carbonate)/gelatin composite scaffolds for tissue engineering, Ind. Eng. Chem. Res. 53 (22) (2014) 9391–9400.   
[140] W.J. Li, C.T. Laurencin, E.J. Caterson, R.S. Tuan, F.K. Ko, Electrospun nanofibrous structure: a novel scaffold for tissue engineering, J. Biomed. Mater. Res. Part A: Off. J. Soc. Biomater. Jpn. Soc. Biomater. Aust. Soc. Biomater. Kor. Soc. Biomater. 60 (4) (2002) 613–621.   
[141] H. Bai, C. Huang, H. Xiu, Q. Zhang, H. Deng, K. Wang, F. Chen, Q. Fu, Significantly improving oxygen barrier properties of polylactide via constructing parallelaligned shish-kebab-like crystals with well-interlocked boundaries, Biomacromolecules 15 (4) (2014) 1507–1514.   
[142] M. Fujita, Y. Takikawa, S. Teramachi, Y. Aoyagi, T. Hiraishi, Y. Doi, Morphology and enzymatic degradation of oriented thin film of ultrahigh molecular weight poly [(R)-3-hydroxybutyrate], Biomacromolecules 5 (5) (2004) 1787–1791.   
[143] K. Maji, S. Dasgupta, K. Pramanik, A. Bissoyi, Preparation and evaluation of ge latin-chitosan-nanobioglass 3D porous scaffold for bone tissue engineering, Int. J. Biomater. (2016) 2016.   
[144] P. Chen, L. Liu, J. Pan, J. Mei, C. Li, Y. Zheng, Biomimetic composite scaffold of hydroxyapatite/gelatin-chitosan core-shell nanofibers for bone tissue engineering, Mater. Sci. Eng. C 97 (2019) 325–335.   
[145] Y. Huang, X. Zhang, A. Wu, H. Xu, An injectable nano-hydroxyapatite (n-HA)/ glycol chitosan (G-CS)/hyaluronic acid (HyA) composite hydrogel for bone tissue engineering, RSC Adv. 6 (40) (2016) 33529–33536.   
[146] Y. Hu, J. Chen, T. Fan, Y. Zhang, Y. Zhao, X. Shi, Q. Zhang, Biomimetic miner alized hierarchical hybrid scaffolds based on in situ synthesis of nano-hydroxyapatite/chitosan/chondroitin sulfate/hyaluronic acid for bone tissue engineering, Colloids Surf. B Biointerfaces 157 (2017) 93–100.   
[147] A. Gilarska, J. Lewandowska-Łańcucka, W. Horak, M. Nowakowska, Collagen/ chitosan/hyaluronic acid–based injectable hydrogels for tissue engineering applications–design, physicochemical and biological characterization, Colloids Surf. B Biointerfaces 170 (2018) 152–162.   
[148] C. Arakawa, R. Ng, S. Tan, S. Kim, B. Wu, M. Lee, Photopolymerizable chitosan–collagen hydrogels for bone tissue engineering, J. Tissue Eng. Regen. Med. 11 (1) (2017) 164–174.   
[149] S. Aliramaji, A. Zamanian, M. Mozafari, Super-paramagnetic responsive silk fibroin/chitosan/magnetite scaffolds with tunable pore structures for bone tissue engineering applications, Mater. Sci. Eng. C 70 (2017) 736–744.   
[150] X.-y. Zhang, Y.-p. Chen, J. Han, J. Mo, P.-f. Dong, Y.-h. Zhuo, Y. Feng, Biocompatiable silk fibroin/carboxymethyl chitosan/strontium substituted hydroxyapatite/cellulose nanocrystal composite scaffolds for bone tissue engineering, Int. J. Biol. Macromol. (2019).   
[151] H.-L. Kim, G.-Y. Jung, J.-H. Yoon, J.-S. Han, Y.-J. Park, D.-G. Kim, M. Zhang, D.- J. Kim, Preparation and characterization of nano-sized hydroxyapatite/alginate/ chitosan composite scaffolds for bone tissue engineering, Mater. Sci. Eng. C 54 (2015) 20–25.   
[152] J. Venkatesan, I. Bhatnagar, S.-K. Kim, Chitosan-alginate biocomposite containing fucoidan for bone tissue engineering, Mar. Drugs 12 (1) (2014) 300–316.   
[153] C.D. Moreira, S.M. Carvalho, R.G. Sousa, H.S. Mansur, M.M. Pereira, Nanostructured chitosan/gelatin/bioactive glass in situ forming hydrogel composites as a potential injectable matrix for bone tissue engineering, Mater. Chem. Phys. 218 (2018) 304–316.   
[154] E. Ruel-Gariepy, J.-C. Leroux, In situ-forming hydrogels—review of temperaturesensitive systems, Eur. J. Pharm. Biopharm. 58 (2) (2004) 409–426.   
[155] M. Buttner, S. Moller, M. Keller, D. Huster, J. Schiller, M. Schnabelrauch, P. Dieter, U. Hempel, Over-sulfated chondroitin sulfate derivatives induce osteogenic

differentiation of hMSC independent of BMP-2 and TGF-beta1 signalling, J. Cell. Physiol. 228 (2) (2013) 330–340. [156] C.M. Stanford, M. Solursh, J.C. Keller, Significant role of adhesion properties of primary osteoblast‐like cells in early adhesion events for chondroitin sulfate and dermatan sulfate surface molecules, J. Biomed. Mater. Res. Part A: Off. J. Soc. Biomater. Jpn. Soc. Biomater. Aust. Soc. Biomater. Kor. Soc. Biomater. 47 (3) (1999) 345–352. [157] H.D. Kim, E.A. Lee, Y.-H. An, S.L. Kim, S.S. Lee, S.J. Yu, H.L. Jang, K.T. Nam, S.G. Im, N.S. Hwang, Chondroitin sulfate-based biomineralizing surface Hydrogels for bone tissue engineering, ACS Appl. Mater. Interfaces 9 (26) (2017) 21639–21650. [158] H. Fan, L. Wang, K. Zhao, N. Li, Z. Shi, Z. Ge, Z. Jin, Fabrication, mechanical properties, and biocompatibility of graphene-reinforced chitosan composites, Biomacromolecules 11 (9) (2010) 2345–2351. [159] E. Kolanthai, P.A. Sindu, D.K. Khajuria, S.C. Veerla, D. Kuppuswamy, L.H. Catalani, D.R. Mahapatra, Graphene oxide—a tool for the preparation of chemically crosslinking free alginate–chitosan–collagen scaffolds for bone tissue engineering, ACS Appl. Mater. Interfaces 10 (15) (2018) 12441–12452. [160] S. Saravanan, A. Chawla, M. Vairamani, T. Sastry, K. Subramanian, N. Selvamurugan, Scaffolds containing chitosan, gelatin and graphene oxide for bone tissue regeneration in vitro and in vivo, Int. J. Biol. Macromol. 104 (2017) 1975–1985. [161] S. Türk, I. Altınsoy, G.Ç. Efe, M. Ipek, M. Özacar, C. Bindal, 3D porous collagen/ functionalized multiwalled carbon nanotube/chitosan/hydroxyapatite composite scaffolds for bone tissue engineering, Mater. Sci. Eng. C 92 (2018) 757–768. [162] S. Gholizadeh, F. Moztarzadeh, N. Haghighipour, L. Ghazizadeh, F. Baghbani, M.A. Shokrgozar, Z. Allahyari, Preparation and characterization of novel functionalized multiwalled carbon nanotubes/chitosan/β-Glycerophosphate scaffolds for bone tissue engineering, Int. J. Biol. Macromol. 97 (2017) 365–372. [163] P. Sivashankari, M. Prabaharan, Chitosan/carbon-based Nanomaterials as Scaffolds for Tissue Engineering, Biopolymer-Based Composites, Elsevier, 2017, pp. 381–397. [164] Y. Chen, L. Chen, H. Bai, L. Li, Graphene oxide–chitosan composite hydrogels as broad-spectrum adsorbents for water purification, J. Mater. Chem. 1 (6) (2013) 1992–2001. [165] A. Aidun, A. Safaei Firoozabady, M. Moharrami, A. Ahmadi, N. haghighipour, S. Bonakdar, S. Faghihi, Graphene oxide incorporated polycaprolactone/chitosan/ collagen electrospun scaffold: enhanced osteogenic properties for bone tissue engineering, Artif. Organs 43 (10) (2019) 265–281. [166] Y. Xu, J. Han, Y. Chai, S. Yuan, H. Lin, X. Zhang, Development of porous chitosan/ tripolyphosphate scaffolds with tunable uncross-linking primary amine content for bone tissue engineering, Mater. Sci. Eng. C 85 (2018) 182–190. [167] H.-T. Lu, T.-W. Lu, C.-H. Chen, K.-Y. Lu, F.-L. Mi, Development of nanocomposite scaffolds based on biomineralization of N, O-carboxymethyl chitosan/fucoidan conjugates for bone tissue engineering, Int. J. Biol. Macromol. 120 (2018) 2335–2345. [168] Z. Shahbazarab, A. Teimouri, A.N. Chermahini, M. Azadi, Fabrication and characterization of nanobiocomposite scaffold of zein/chitosan/nanohydroxyapatite prepared by freeze-drying method for bone tissue engineering, Int. J. Biol. Macromol. 108 (2018) 1017–1027. [169] C. Neidlinger-Wilke, F. Galbusera, H. Pratsinis, E. Mavrogonatou, A. Mietsch, D. Kletsas, H.-J. Wilke, Mechanical loading of the intervertebral disc: from the macroscopic to the cellular level, Eur. Spine J. 23 (3) (2014) 333–343. [170] B.R. Whatley, X. Wen, Intervertebral disc (IVD): structure, degeneration, repair and regeneration, Mater. Sci. Eng. C 32 (2) (2012) 61–77. [171] N. Boos, S. Weissbach, H. Rohrbach, C. Weiler, K.F. Spratt, A.G. Nerlich, Classification of age-related changes in lumbar intervertebral discs: 2002 Volvo Award in basic science, Spine 27 (23) (2002) 2631–2644. [172] R.D. Bowles, L.A. Setton, Biomaterials for intervertebral disc regeneration and repair, Biomaterials 129 (2017) 54–67. [173] A. Van Ooij, F.C. Oner, A.J. Verbout, Complications of artificial disc replacement: a report of 27 patients with the SB Charite disc, Spine 28 (2003) 369–383. [174] M. Gore, A. Sadosky, B.R. Stacey, K.-S. Tai, D. Leslie, The burden of chronic low back pain: clinical comorbidities, treatment patterns, and health care costs in usual care settings, Spine 37 (11) (2012) E668–E677. [175] S.B. Rao, C.P. Sharma, Use of chitosan as a biomaterial: studies on its safety and hemostatic potential, J. Biomed. Mater. Res.: Off. J. Soc. Biomater. Jpn. Soc. Biomater. 34 (1) (1997) 21–28. [176] I. Doench, M. Torres-Ramos, A. Montembault, P. Nunes de Oliveira, C. Halimi, E. Viguier, L. Heux, R. Siadous, R. Thiré, A. Osorio-Madrazo, Injectable and gellable chitosan formulations filled with cellulose nanofibers for intervertebral disc tissue engineering, Polymers 10 (11) (2018) 1202. [177] M. Ghorbani, J. Ai, M.R. Nourani, M. Azami, B.H. Beni, S. Asadpour, S. Bordbar, Injectable natural polymer compound for tissue engineering of intervertebral disc: in vitro study, Mater. Sci. Eng. C 80 (2017) 502–508. [178] P. Roughley, C. Hoemann, E. DesRosiers, F. Mwale, J. Antoniou, M. Alini, The potential of chitosan-based gels containing intervertebral disc cells for nucleus pulposus supplementation, Biomaterials 27 (3) (2006) 388–396. [179] Y. Alinejad, A. Adoungotchodo, M.P. Grant, L.M. Epure, J. Antoniou, F. Mwale, S. Lerouge, Injectable chitosan hydrogels with enhanced mechanical properties for nucleus pulposus regeneration, Tissue Eng. 25 (5–6) (2019) 303–313. [180] D. Yuan, Z. Chen, X. Xiang, S. Deng, K. Liu, D. Xiao, L. Deng, G. Feng, The establishment and biological assessment of a whole tissue‐engineered intervertebral disc with PBST fibers and a chitosan hydrogel in vitro and in vivo, J. Biomed. Mater. Res. Part B: Appl. Biomater. 107 (7) (2019) 2305–2316. [181] J.M. Dang, D.D. Sun, Y. Shin-Ya, A.N. Sieber, J.P. Kostuik, K.W. Leong,

Temperature-responsive hydroxybutyl chitosan for the culture of mesenchymal stem cells and intervertebral disk cells, Biomaterials 27 (3) (2006) 406–418. [182] T. Fukunishi, C.A. Best, T. Sugiura, T. Shoji, T. Yi, B. Udelsman, D. Ohst, C.S. Ong, H. Zhang, T. Shinoka, Tissue-engineered small diameter arterial vascular grafts from cell-free nanofiber PCL/chitosan scaffolds in a sheep model, PloS One 11 (7) (2016) e0158555. [183] J.M. Chupa, A.M. Foster, S.R. Sumner, S.V. Madihally, H.W. Matthew, Vascular cell responses to polysaccharide materials:: in vitro and in vivo evaluations, Biomaterials 21 (22) (2000) 2315–2322. [184] L. Zhang, Q. Ao, A. Wang, G. Lu, L. Kong, Y. Gong, N. Zhao, X. Zhang, A sandwich tubular scaffold derived from chitosan for blood vessel tissue engineering, J. Biomed. Mater. Res. Part A: Off. J. Soc. Biomater. Jpn. Soc. Biomater. Aust. Soc. Biomater. Kor. Soc. Biomater. 77 (2) (2006) 277–284. [185] C. Huang, R. Chen, Q. Ke, Y. Morsi, K. Zhang, X. Mo, Electrospun collagen–chitosan–TPU nanofibrous scaffolds for tissue engineered tubular grafts, Colloids Surf. B Biointerfaces 82 (2) (2011) 307–315. [186] J. Zhang, D. Wang, X. Jiang, L. He, L. Fu, Y. Zhao, Y. Wang, H. Mo, J. Shen, Multistructured vascular patches constructed via layer-by-layer self-assembly of heparin and chitosan for vascular tissue engineering applications, Chem. Eng. J. 370 (2019) 1057–1067. [187] R.V. Badhe, D. Bijukumar, D.R. Chejara, M. Mabrouk, Y.E. Choonara, P. Kumar, L.C. du Toit, P.P. Kondiah, V. Pillay, A composite chitosan-gelatin bi-layered, biomimetic macroporous scaffold for blood vessel tissue engineering, Carbohydr. Polym. 157 (2017) 1215–1225. [188] A.P. Zhu, F. Zhao, N. Fang, Regulation of vascular smooth muscle cells on poly (ethylene terephthalate) film by O‐carboxymethylchitosan surface immobilization, J. Biomed. Mater. Res. Part A: Off. J. Soc. Biomater. Jpn. Soc. Biomater. Aust. Soc. Biomater. Kor. Soc. Biomater. 86 (2) (2008) 467–476. [189] N.E. Vrana, Y. Liu, G.B. McGuinness, P.A. Cahill, Characterization of Poly (Vinyl Alcohol)/chitosan Hydrogels as Vascular Tissue Engineering Scaffolds, Macromolecular symposia, Wiley Online Library, 2008, pp. 106–110. [190] I. Fiqrianti, P. Widiyanti, M. Manaf, C. Savira, N. Cahyani, F. Bella, Poly-L-lactic acid (PLLA)-Chitosan-Collagen electrospun tube for vascular graft application, J. Funct. Biomater. 9 (2) (2018) 32. [191] K. Engelmann, J. Bednarz, M. Valtink, Prospects for endothelial transplantation, Exp. Eye Res. 78 (3) (2004) 573–578. [192] W.H. Organization, Universal Eye Health: a Global Action Plan 2014–2019, (2013) Report No.: ISBN 978(92) (2015) 4. [193] P. Kafle, S. Singh, I. Sarkar, L. Surin, Amniotic membrane transplantation with and without limbal stem cell transplantation in chemical eye injury, Nepal. J. Ophthalmol. 7 (1) (2015) 52–55. [194] M.E. Kreft, U. Dragin, Amniotic membrane in tissue engineering and regenerative medicine, Slov. Med. J. 79 (10) (2010). [195] S.H.K. SafiyyaYousaf, Gholam Ali Farzi, Majid Momeni-Moghadam, Ehsaneh Daghigh Ahmadi, Ilida Ortega Asencio, Masoud Mozafari, Farshid Sefat, Scaffolds for corneal tissue engineering, in: F.S. Masoud Mozafari, Anthony Atala (Eds.), Handbook of Tissue Engineering Scaffolds, Woodhead Publishing, United Kingdom, 2019, pp. 649–672. [196] S. Wang, W. Liu, B. Han, L. Yang, Study on a hydroxypropyl chitosan–gelatin based scaffold for corneal stroma tissue engineering, Appl. Surf. Sci. 255 (20) (2009) 8701–8705. [197] F. Zahir-Jouzdani, M. Mahbod, M. Soleimani, F. Vakhshiteh, E. Arefian, S. Shahosseini, R. Dinarvand, F. Atyabi, Chitosan and thiolated chitosan: novel therapeutic approach for preventing corneal haze after chemical injuries, Carbohydr. Polym. 179 (2018) 42–49. [198] B. Ozcelik, K.D. Brown, A. Blencowe, M. Daniell, G.W. Stevens, G.G. Qiao, Ultrathin chitosan–poly (ethylene glycol) hydrogel films for corneal tissue engineering, Acta Biomater. 9 (5) (2013) 6594–6605. [199] Y.-H. Wang, T.-H. Young, T.-J. Wang, Investigating the effect of chitosan/polycaprolactone blends in differentiation of corneal endothelial cells and extracellular matrix compositions, Exp. Eye Res. 185 (2019) 107679. [200] R.V. Shevchenko, S.L. James, S.E. James, A review of tissue-engineered skin bioconstructs available for skin reconstruction, J. R. Soc. Interface 7 (43) (2009) 229–258. [201] D. Hutmacher, J. Goh, S. Teoh, An introduction to biodegradable materials for tissue engineering applications, Ann. Acad. Med. Singapore 30 (2) (2001) 183–191. [202] L. Ma, C. Gao, Z. Mao, J. Zhou, J. Shen, X. Hu, C. Han, Collagen/chitosan porous scaffolds with improved biostability for skin tissue engineering, Biomaterials 24 (26) (2003) 4833–4841. [203] R.B. Trinca, C.B. Westin, J.A.F. da Silva, Â.M. Moraes, Electrospun multilayer chitosan scaffolds as potential wound dressings for skin lesions, Eur. Polym. J. 88 (2017) 161–170. [204] J. Ma, H. Wang, B. He, J. Chen, A preliminary in vitro study on the fabrication and tissue engineering applications of a novel chitosan bilayer material as a scaffold of human neofetal dermal fibroblasts, Biomaterials 22 (4) (2001) 331–336. [205] V.T. Tchemtchoua, G. Atanasova, A. Aqil, P. Filée, N. Garbacki, O. Vanhooteghem, C. Deroanne, A. Noël, C. Jérome, B. Nusgens, Development of a chitosan nanofibrillar scaffold for skin repair and regeneration, Biomacromolecules 12 (9) (2011) 3194–3204. [206] S.D. Sarkar, B.L. Farrugia, T.R. Dargaville, S. Dhara, Chitosan–collagen scaffolds with nano/microfibrous architecture for skin tissue engineering, J. Biomed. Mater. Res. Part A: An Official Journal of The Society for Biomaterials, The Japanese Society for Biomaterials, and The Australian Society for Biomaterials and the Korean Society for Biomaterials 101 (12) (2013) 3482–3492. [207] P.N. Ramadhani, Efek Variasi Komposisi Kolagen-Kitosan-Gliserol Terhadap

Karakterisasi Scaffold Untuk Gingival Recession Therapy, Universitas Airlangga, 2018. [208] C.-m. Han, L.-p. Zhang, J.-z. Sun, H.-f. Shi, J. Zhou, C.-y. Gao, Application of collagen-chitosan/fibrin glue asymmetric scaffolds in skin tissue engineering, J. Zhejiang Univ. - Sci. B 11 (7) (2010) 524–530. [209] M. Pezeshki-Modaress, M. Zandi, S. Rajabi, Tailoring the gelatin/chitosan electrospun scaffold for application in skin tissue engineering: an in vitro study, Prog. Biomater. 7 (3) (2018) 207–218. [210] H. Liu, Y. Yin, K. Yao, Construction of chitosan—gelatin—hyaluronic acid artificial skin in vitro, J. Biomater. Appl. 21 (4) (2007) 413–430. [211] H. Liu, J. Mao, K. Yao, G. Yang, L. Cui, Y. Cao, A study on a chitosan-gelatinhyaluronic acid scaffold as artificial skin in vitro and its tissue engineering applications, J. Biomater. Sci. Polym. Ed. 15 (1) (2004) 25–40. [212] A. Pocaterra, S. Caruso, S. Bernardi, L. Scagnoli, M.A. Continenza, R. Gatto, Effectiveness of platelet-rich plasma as an adjunctive material to bone graft: a systematic review and meta-analysis of randomized controlled clinical trials, Int. J. Oral Maxillofac. Surg. 45 (8) (2016) 1027–1034. [213] I. Laidmäe, K. Ērglis, A. Cēbers, P.A. Janmey, R. Uibo, Salmon fibrinogen and chitosan scaffold for tissue engineering: in vitro and in vivo evaluation, J. Mater. Sci. Mater. Med. 29 (12) (2018) 182. [214] A. Madni, R. Khan, M. Ikram, S.S. Naz, T. Khan, F. Wahid, Fabrication and characterization of chitosan–vitamin c–lactic acid composite membrane for potential skin tissue engineering, Int. J. Polym. Sci. 2019 (2019). [215] Q. Hu, X. Qian, B. Li, J. Shen, Studies on chitosan rods prepared by in situ precipitation method, Chem. J. Chin. Univ. 24 (3) (2003) 528–531. [216] K. Ahtiainen, L. Sippola, M. Nurminen, B. Mannerström, S. Haimi, R. Suuronen, J. Hyttinen, T. Ylikomi, M. Kellomäki, S. Miettinen, Effects of chitosan and bioactive glass modifications of knitted and rolled polylactide‐based 96/4 L/D scaffolds on chondrogenic differentiation of adipose stem cells, J. Tissue Eng. Regen. Med. 9 (1) (2015) 55–65. [217] Z.-k. Wang, Q.-l. Hu, R.-c. Fei, J.-h. Ke, J.-c. Shen, Chitosan rod reinforced by selfcrosslinking through thermal treatment, Front. Mater. Sci. China 2 (2) (2008) 205–208. [218] Z. Wang, Q. Hu, Y. Wang, Preparation of chitosan rods with excellent mechanical properties: one candidate for bone fracture internal fixation, Sci. China Chem. 54 (2) (2011) 380–384. [219] Z. Wang, Q. Hu, L. Cai, Chitin fiber and chitosan 3D composite rods, Int. J. Polym. Sci. 2010 (2010). [220] Z. Wang, Q. Hu, Preparation and properties of three-dimensional hydroxyapatite/ chitosan nanocomposite rods, Biomed. Mater. 5 (4) (2010) 045007. [221] X.M. Pu, Z.Z. Sun, Z.Q. Hou, Y. Yang, Q.Q. Yao, Q.Q. Zhang, Fabrication of chitosan/hydroxylapatite composite rods with a layer‐by‐layer structure for fracture fixation, J. Biomed. Mater. Res. B Appl. Biomater. 100 (5) (2012) 1179–1189. [222] Z. Wang, H. Zhao, L. Fan, J. Lin, P. Zhuang, W.Z. Yuan, Q. Hu, J.Z. Sun, B.Z. Tang, Chitosan rods reinforced by aligned multiwalled carbon nanotubes via magneticfield-assistant in situ precipitation, Carbohydr. Polym. 84 (3) (2011) 1126–1132. [223] T. Kawai, T. Yamada, A. Yasukawa, Y. Koyama, T. Muneta, K. Takakuda, Biological fixation of fibrous materials to bone using chitin/chitosan as a bone formation accelerator, J. Biomed. Mater. Res. Part A: Off. J. Soc. Biomater. Jpn. Soc. Biomater. Aust. Soc. Biomater. Kor. Soc. Biomater. 88 (1) (2009) 264–270. [224] S. Husain, K.H. Al-Samadani, S. Najeeb, M.S. Zafar, Z. Khurshid, S. Zohaib, S.B. Qasim, Chitosan biomaterials for current and potential dental applications, Materials 10 (6) (2017) 602. [225] R.A. Hanafy, D. Mostafa, A. Abd El-Fattah, S. Kandil, Biomimetic chitosan against bioinspired nanohydroxyapatite for repairing enamel surfaces, Bioinspired, Biomimetic Nanobiomaterials (2019) 1–10. [226] J. Moradian-Oldak, R. Qichao, Chitosan-amelogenin Hydrogel for in Situ Enamel Growth, Google Patents, 2019. [227] L. Gu, X. Cai, J. Guo, D. Pashley, L. Breschi, H. Xu, X. Wang, F. Tay, L. Niu, Chitosan-based extrafibrillar demineralization for dentin bonding, J. Dent. Res. 98 (2) (2019) 186–193. [228] S. Grobler, V. Perchyonok, R. Mulder, D. Moodley, Towards bioactive dental restorative materials with chitosan and Na-nodiamonds: evaluation and application, Int. J. Dent. Oral Sci. 2 (9) (2015) 147–154. [229] K.H. Park, S.-J. Kim, M.-J. Hwang, H.-J. Song, Y.-J. Park, Pulse electrodeposition of hydroxyapatite/chitosan coatings on titanium substrate for dental implant, Colloid Polym. Sci. 295 (10) (2017) 1843–1849. [230] E.C. Shen, C. Wang, E. Fu, C.Y. Chiang, T.T. Chen, S. Nieh, Tetracycline release from tripolyphosphate–chitosan cross‐linked sponge: a preliminary in vitro study, J. Periodontal. Res. 43 (6) (2008) 642–648. [231] A.C. Akman, R.S. Tığlı, M. Gümüşderelioğlu, R.M. Nohutcu, bFGF‐loaded Ha‐chitosan, A promising scaffold for periodontal tissue engineering, J. Biomed. Mater. Res. Part A: Off. J. Soc. Biomater. Jpn. Soc. Biomater. Aust. Soc. Biomater. Kor. Soc. Biomater. 92 (3) (2010) 953–962. [232] L. Peng, X. Cheng, R. Zhuo, J. Lan, Y. Wang, B. Shi, S. Li, Novel gene‐activated matrix with embedded chitosan/plasmid DNA nanoparticles encoding PDGF for periodontal tissue engineering, J. Biomed. Mater. Res. Part A: Off. J. Soc. Biomater. Jpn. Soc. Biomater. Aust. Soc. Biomater. Kor. Soc. Biomater. 90 (2) (2009) 564–576. [233] Z. Soran, R.S.T. Aydın, M. Gümüşderelioğlu, Chitosan scaffolds with BMP-6 loaded alginate microspheres for periodontal tissue engineering, J. Microencapsul. 29 (8) (2012) 770–780. [234] K. Lee, E.A. Silva, D.J. Mooney, Growth factor delivery-based tissue engineering: general approaches and a review of recent developments, J. R. Soc. Interface 8 (55) (2010) 153–170. [235] J. Mota, N. Yu, S.G. Caridade, G.M. Luz, M.E. Gomes, R.L. Reis, J.A. Jansen,

X.F. Walboomers, J.F. Mano, Chitosan/bioactive glass nanoparticle composite membranes for periodontal regeneration, Acta Biomater. 8 (11) (2012) 4173–4180.   
[236] L. Cao, B. Cao, C. Lu, G. Wang, L. Yu, J. Ding, An injectable hydrogel formed by in situ cross-linking of glycol chitosan and multi-benzaldehyde functionalized PEG analogues for cartilage tissue engineering, J. Mater. Chem. B 3 (7) (2015) 1268–1280.   
[237] D. Sadeghi, S. Karbasi, S. Razavi, S. Mohammadi, M.A. Shokrgozar, S. Bonakdar, Electrospun poly (hydroxybutyrate)/chitosan blend fibrous scaffolds for cartilage tissue engineering, J. Appl. Polym. Sci. 133 (47) (2016).   
[238] M.A. Shamekhi, A. Rabiee, H. Mirzadeh, H. Mahdavi, D. Mohebbi-Kalhori, M.B. Eslaminejad, Fabrication and characterization of hydrothermal cross-linked chitosan porous scaffolds for cartilage tissue engineering applications, Mater. Sci. Eng. C 80 (2017) 532–542.   
[239] T. Tithito, P. Suntornsaratoon, N. Charoenphandhu, J. Thongbunchoo, N. Krishnamra, I.M. Tang, W. Pon-On, Fabrication of biocomposite scaffolds made with modified hydroxyapatite inclusion of chitosan-grafted-poly (methyl methacrylate) for bone tissue engineering, Biomed. Mater. 14 (2) (2019) 025013.   
[240] X. Li, H.-M. Yin, K. Su, G.-S. Zheng, C.-Y. Mao, W. Liu, P. Wang, Z. Zhang, J.-Z. Xu, Z.-M. Li, Polydopamine-assisted anchor of chitosan onto porous composite scaffolds for accelerating bone regeneration, ACS Biomater. Sci. Eng. 5 (6) (2019) 2998–3006.   
[241] C.D. Moreira, S.M. Carvalho, R.M. Florentino, A. França, B.S. Okano, C.M. Rezende, H.S. Mansur, M.M. Pereira, Injectable chitosan/gelatin/bioactive glass nanocomposite hydrogels for potential bone regeneration: in vitro and in vivo analyses, Int. J. Biol. Macromol. 132 (2019) 811–821.   
[242] T. Wen, C. Zhang, D. Ruan, F. Li, J. Ma, Constructing tissue engineered nucleus pulposus with adipose-derived stem cells and an injectable thermosensitive chitosan scaffold, J. Biomater. Tissue Eng. 4 (12) (2014) 1073–1079.   
[243] M.B. Nair, G. Baranwal, P. Vijayan, K.S. Keyan, R. Jayakumar, Composite hydrogel of chitosan–poly (hydroxybutyrate-co-valerate) with chondroitin sulfate nanoparticles for nucleus pulposus tissue engineering, Colloids Surf. B Biointerfaces 136 (2015) 84–92.   
[244] F. Yang, D. Xiao, Q. Zhao, Z. Chen, K. Liu, S. Chen, X. Sun, Q. Yue, R. Zhang, G. Feng, Fabrication of a novel whole tissue-engineered intervertebral disc for intervertebral disc regeneration in the porcine lumbar spine, RSC Adv. 8 (68) (2018) 39013–39021.   
[245] Z. Li, H. Shim, M.O. Cho, I.S. Cho, J.H. Lee, S.-W. Kang, B. Kwon, K.M. Huh, Thermo-sensitive injectable glycol chitosan-based hydrogel for treatment of de generative disc disease, Carbohydr. Polym. 184 (2018) 342–353.   
[246] F. Du, H. Wang, W. Zhao, D. Li, D. Kong, J. Yang, Y. Zhang, Gradient nanofibrous chitosan/poly ϵ-caprolactone scaffolds as extracellular microenvironments for vascular tissue engineering, Biomaterials 33 (3) (2012) 762–770.   
[247] M. Yar, G. Gigliobianco, L. Shahzadi, L. Dew, S.A. Siddiqi, A.F. Khan, A.A. Chaudhry, I.u. Rehman, S. MacNeil, Production of chitosan PVA PCL hydrogels to bind heparin and induce angiogenesis, Int. J. Polym. Mater. Polym. Biomater. 65 (9) (2016) 466–476.   
[248] S. Ulag, C. Kalkandelen, F.N. Oktar, M. Uzun, Y.M. Sahin, B. Karademir, S. Arslan, I.T. Ozbolat, M. Mahirogullari, O. Gunduz, 3D printing artificial blood vessel constructs using PCL/Chitosan/Hydrogel biocomposites, ChemistrySelect 4 (8) (2019) 2387–2391.   
[249] M. Rafat, F. Li, P. Fagerholm, N.S. Lagali, M.A. Watsky, R. Munger, T. Matsuura, M. Griffith, PEG-stabilized carbodiimide crosslinked collagen–chitosan hydrogels for corneal tissue engineering, Biomaterials 29 (29) (2008) 3960–3972.   
[250] Y. Liang, W. Liu, B. Han, C. Yang, Q. Ma, W. Zhao, M. Rong, H. Li, Fabrication and characters of a corneal endothelial cells scaffold based on chitosan, J. Mater. Sci. Mater. Med. 22 (1) (2011) 175–183.   
[251] J.-Y. Lai, Biocompatibility of genipin and glutaraldehyde cross-linked chitosan materials in the anterior chamber of the eye, Int. J. Mol. Sci. 13 (9) (2012) 10970–10985.   
[252] L. Guan, H. Ge, X. Tang, S. Su, P. Tian, N. Xiao, H. Zhang, L. Zhang, P. Liu, Use of a silk fibroin-chitosan scaffold to construct a tissue-engineered corneal stroma, Cells Tissues Organs 198 (3) (2013) 190–197.   
[253] M. Grolik, D. Kuźmicz, D. Dobrowolski, B. Wowra, E. Wylęgała, M. Nowakowska, K. Szczubiałka, Silicone-modified chitosan membranes for corneal epithelium tissue engineering, J. Biomater. Tissue Eng. 8 (3) (2018) 374–383.   
[254] W. Xu, K. Liu, T. Li, W. Zhang, Y. Dong, J. Lv, W. Wang, J. Sun, M. Li, M. Wang, An in situ hydrogel based on carboxymethyl chitosan and sodium alginate dialdehyde for corneal wound healing after alkali burn, J. Biomed. Mater. Res. 107 (4) (2019) 742–754.   
[255] M.A. Seyed, K. Vijayaraghavan, Evaluation of an improved chitosan scaffold crosslinked with polyvinyl alcohol and amine coupling through 1-ethyl-3-(3-dimethyl aminopropyl)-carbodiimide (EDC) and 2 N-hydroxysuccinimide (NHS) for corneal applications, Open Access Maced. J. Med. Sci. 6 (9) (2018) 1561.   
[256] W. Xu, Z. Wang, Y. Liu, L. Wang, Z. Jiang, T. Li, W. Zhang, Y. Liang, Carboxymethyl chitosan/gelatin/hyaluronic acid blended-membranes as epithelia transplanting scaffold for corneal wound healing, Carbohydr. Polym. 192 (2018) 240–250.   
[257] T. Prasad, E. Shabeena, D. Vinod, T. Kumary, P.A. Kumar, Characterization and in vitro evaluation of electrospun chitosan/polycaprolactone blend fibrous mat for skin tissue engineering, J. Mater. Sci. Mater. Med. 26 (1) (2015) 28.   
[258] C. Tangsadthakun, S. Kanokpanont, N. Sanchavanakit, T. Banaprasert, S. Damrongsakkul, Properties of collagen/chitosan scaffolds for skin tissue engineering, J. Met. Mater. Miner. 16 (1) (2017).   
[259] T. Agarwal, R. Narayan, S. Maji, S. Behera, S. Kulanthaivel, T.K. Maiti, I. Banerjee, K. Pal, S. Giri, Gelatin/carboxymethyl chitosan based scaffolds for dermal tissue engineering applications, Int. J. Biol. Macromol. 93 (2016) 1499–1506.   
[260] S.L. Levengood, A.E. Erickson, F.-c. Chang, M. Zhang, Chitosan–poly (caprolactone) nanofibers for skin repair, J. Mater. Chem. B 5 (9) (2017) 1822–1833.   
[261] S. Gomes, G. Rodrigues, G. Martins, C. Henriques, J.C. Silva, Evaluation of nanofibrous scaffolds obtained from blends of chitosan, gelatin and polycaprolactone for skin tissue engineering, Int. J. Biol. Macromol. 102 (2017) 1174–1185.   
[262] I. Yousefi, M. Pakravan, H. Rahimi, A. Bahador, Z. Farshadzadeh, I. Haririan, An investigation of electrospun Henna leaves extract-loaded chitosan based nanofibrous mats for skin tissue engineering, Mater. Sci. Eng. C 75 (2017) 433–444.   
[263] L.H. Dang, T.H. Nguyen, H.L.B. Tran, V.N. Doan, N.Q. Tran, Injectable nanocurcumin-formulated chitosan-g-pluronic hydrogel exhibiting a great potential for burn treatment, J. Healthc. Eng. 2018 (2018).   
[264] H. Cheng, C. Li, Y. Jiang, B. Wang, F. Wang, Z. Mao, H. Xu, L. Wang, X. Sui, Facile preparation of polysaccharide-based sponges and their potential application in wound dressing, J. Mater. Chem. B 6 (4) (2018) 634–640.   
[265] A. Jafari, S. Hassanajili, N. Azarpira, M.B. Karimi, B. Geramizadeh, Development of thermal-crosslinkable chitosan/maleic terminated polyethylene glycol hydrogels for full thickness wound healing: in vitro and in vivo evaluation, Eur. Polym. J. 118 (2019) 113–127.   
[266] N.T. Phuong, V. Anh Ho, D. Hai Nguyen, N.C. Khoa, T.N. Quyen, Y. Lee, K.D. Park, Enzyme-mediated fabrication of an oxidized chitosan hydrogel as a tissue sealant, J. Bioact. Compat Polym. 30 (4) (2015) 412–423.   
[267] B. Balakrishnan, D. Soman, U. Payanam, A. Laurent, D. Labarre, A. Jayakrishnan, A novel injectable tissue adhesive based on oxidized dextran and chitosan, Acta Biomater. 53 (2017) 343–354.   
[268] H. Nomata, M. Nakaishi, K. Takakuda, Enhanced biological fixation of ligaments to bone tissues utilizing chitin fabrics, J. Biomed. Mater. Res. B Appl. Biomater. 106 (6) (2018) 2355–2360.   
[269] Q. Ji, J. Deng, X. Yu, Q. Xu, H. Wu, J. Pan, Modulation of pro-inflammatory mediators in LPS-stimulated human periodontal ligament cells by chitosan and quaternized chitosan, Carbohydr. Polym. 92 (1) (2013) 824–829.   
[270] M. Kilicarslan, M. Gumustas, S. Yildiz, T. Baykara, Preparation and characterization of chitosan-based spray-dried microparticles for the delivery of clindamycin phosphate to periodontal pockets, Curr. Drug Deliv. 11 (1) (2014) 98–111.   
[271] D.G. Miranda, S.M. Malmonge, D.M. Campos, N.G. Attik, B. Grosgogeat, K. Gritsch, A chitosan‐hyaluronic acid hydrogel scaffold for periodontal tissue engineering, J. Biomed. Mater. Res. B Appl. Biomater. 104 (8) (2016) 1691–1702.   
[272] E. Varoni, S. Vijayakumar, E. Canciani, A. Cochis, L. De Nardo, G. Lodi, L. Rimondini, M. Cerruti, Chitosan-based trilayer scaffold for multitissue periodontal regeneration, J. Dent. Res. 97 (3) (2018) 303–311.   
[273] A.I. Özdoğan, Y.D. İlarslan, K. Kösemehmetoğlu, G. Akca, H.B. Kutlu, E. Comerdov, A.B. Iskit, S. Şenel, In vivo evaluation of chitosan based local delivery systems for atorvastatin in treatment of periodontitis, Int. J. Pharm. 550 (1–2) (2018) 470–476.   
[274] R. Shen, W. Xu, Y. Xue, L. Chen, H. Ye, E. Zhong, Z. Ye, J. Gao, Y. Yan, The use of chitosan/PLA nano-fibers by emulsion electrospinning for periodontal tissue engineering, Artificial cells, Artif. Cells Nanomed. Biotechnol. 46 (sup2) (2018) 419–430.   
[275] T. Sukpaita, S. Chirachanchai, P. Suwattanachai, V. Everts, A. Pimkhaokham, R.S. Ampornaramveth, In Vivo bone regeneration induced by a scaffold of chitosan/dicarboxylic acid seeded with human periodontal ligament cells, Int. J. Mol. Sci. 20 (19) (2019) 4883.   
[276] Y. Li, Z. Qiao, F. Yu, H. Hu, Y. Huang, Q. Xiang, Q. Zhang, Y. Yang, Y. Zhao, Transforming growth factor-β3/chitosan sponge (TGF-β3/CS) facilitates osteogenic differentiation of human periodontal ligament stem cells, Int. J. Mol. Sci. 20 (20) (2019) 4982.   
[277] Y. Xue, X. Hong, J. Gao, R. Shen, Z. Ye, Preparation and biological characterization of the mixture of poly (lactic-co-glycolic acid)/chitosan/ag nanoparticles for periodontal tissue engineering, Int. J. Nanomed. 14 (2019) 483.